/*
 * Decompiled with CFR 0.152.
 */
package io.github.davidqf555.minecraft.multiverse.common.world;

import com.mojang.datafixers.util.Pair;
import io.github.davidqf555.minecraft.multiverse.common.world.blocks.RiftBlock;
import io.github.davidqf555.minecraft.multiverse.common.world.blocks.RiftPlacement;
import io.github.davidqf555.minecraft.multiverse.common.world.blocks.RiftTileEntity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public final class RiftPlacementHelper {
    private static final Predicate<BlockState> REPLACE = Feature.isReplaceable((TagKey)BlockTags.FEATURES_CANNOT_REPLACE);

    private RiftPlacementHelper() {
    }

    public static void place(LevelWriter writer, LevelReader reader, BlockState rift, ResourceKey<Level> target, Vec3 center, Vec3 normal, float angle, double width, double height, ReplacementType replacement) {
        if ((normal = normal.normalize()).lengthSqr() == 0.0) {
            normal = new Vec3(0.0, 1.0, 0.0);
        }
        Vec3 n = normal;
        Vec3[][] vertices = RiftPlacementHelper.calculateVertices(center, n, angle, width, height);
        RiftPlacementHelper.iterate(vertices, reader.getMinY(), reader.getMaxY(), pos -> {
            Vec3 corner;
            Vec3[] polygon;
            BlockState state = reader.getBlockState(pos);
            if (replacement.canReplace(reader, (BlockPos)pos, state) && (polygon = RiftPlacementHelper.calculateSectionPolygon(vertices, n, AABB.unitCubeFromLowerCorner((Vec3)(corner = Vec3.atLowerCornerOf((Vec3i)pos))))).length >= 3) {
                BlockState base = rift;
                Fluid fluid = reader.getFluidState(pos).getType();
                if (replacement.hasDrops()) {
                    writer.destroyBlock(pos, true);
                }
                if (fluid == Fluids.WATER) {
                    base = (BlockState)base.setValue(RiftBlock.FLUID, (Comparable)((Object)RiftBlock.LoggedFluid.WATER));
                } else if (fluid == Fluids.LAVA) {
                    base = (BlockState)base.setValue(RiftBlock.FLUID, (Comparable)((Object)RiftBlock.LoggedFluid.LAVA));
                }
                writer.setBlock(pos, base, 3);
                BlockEntity tile = reader.getBlockEntity(pos);
                if (tile instanceof RiftTileEntity) {
                    ((RiftTileEntity)tile).setTarget(target);
                    ((RiftTileEntity)tile).setCollision(polygon);
                    ((RiftTileEntity)tile).setParent(new RiftPlacement(center.subtract(corner), width, height, n, angle));
                }
            }
        });
    }

    public static Vec3[] calculateVerticesAt(RiftPlacement placement, BlockPos pos) {
        return RiftPlacementHelper.calculateSectionPolygon(RiftPlacementHelper.calculateVertices(placement.center(), placement.normal(), placement.angle(), placement.width(), placement.height()), placement.normal(), AABB.unitCubeFromLowerCorner((Vec3)Vec3.atLowerCornerOf((Vec3i)pos)));
    }

    public static Vec3[][] calculateVertices(Vec3 center, Vec3 normal, float angle, double width, double height) {
        Vec3[] axis = new Vec3[2];
        axis[0] = normal.cross(new Vec3(0.0, 1.0, 0.0)).normalize();
        if (axis[0].lengthSqr() == 0.0) {
            axis[0] = new Vec3(1.0, 0.0, 0.0);
        }
        axis[1] = normal.cross(axis[0]).normalize();
        for (int i = 0; i < 2; ++i) {
            Vec3 parallel = normal.scale(normal.dot(axis[i]) / normal.lengthSqr());
            Vec3 perp = axis[i].subtract(parallel);
            Vec3 cross = normal.cross(perp).normalize();
            Vec3 rotate = perp.scale((double)Mth.cos((float)(angle * ((float)Math.PI / 180)))).add(cross.scale((double)Mth.sin((float)(angle * ((float)Math.PI / 180))) * perp.length()));
            axis[i] = rotate.add(parallel);
        }
        Vec3[][] vertices = new Vec3[2][4];
        vertices[0][0] = center.add(axis[0].scale(width / 2.0));
        vertices[0][1] = center.add(axis[1].scale(height / 2.0));
        vertices[0][2] = center.add(axis[0].scale(-width / 2.0));
        vertices[0][3] = center.add(axis[1].scale(-height / 2.0));
        vertices[1][1] = vertices[0][0];
        vertices[1][2] = vertices[0][1];
        vertices[1][3] = vertices[0][2];
        vertices[1][0] = vertices[0][3];
        return vertices;
    }

    private static void iterate(Vec3[][] vertices, int minBuild, int maxBuild, Consumer<BlockPos> effect) {
        int i;
        double[] allY = Arrays.stream(vertices[0]).mapToDouble(Vec3::y).sorted().toArray();
        for (i = 0; i < allY.length && !(allY[i] > (double)minBuild); ++i) {
        }
        double minY = allY[0];
        double maxY = allY[allY.length - 1];
        int iMin = Math.max(Mth.floor((double)minY), minBuild);
        int iMax = Math.min(Mth.floor((double)maxY), maxBuild);
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int y = iMin; y <= iMax; ++y) {
            ArrayList<Double> crit = new ArrayList<Double>();
            if ((double)y >= minY) {
                crit.add(Double.valueOf(y));
            }
            int high = y + 1;
            while (i < allY.length && allY[i] < (double)high) {
                if (crit.isEmpty() || (Double)crit.getLast() != allY[i]) {
                    crit.add(allY[i]);
                }
                ++i;
            }
            if ((double)high <= maxY && (crit.isEmpty() || (Double)crit.getLast() != (double)high)) {
                crit.add(Double.valueOf(high));
            }
            ArrayList<Point2D> points = new ArrayList<Point2D>();
            Iterator iterator = crit.iterator();
            while (iterator.hasNext()) {
                double val = (Double)iterator.next();
                for (int j = 0; j < vertices[0].length; ++j) {
                    Vec3 dir = vertices[1][j].subtract(vertices[0][j]);
                    if (dir.y() == 0.0) {
                        points.add(new Point2D(vertices[0][j].x(), vertices[0][j].z()));
                        points.add(new Point2D(vertices[1][j].x(), vertices[1][j].z()));
                        continue;
                    }
                    double t = (val - vertices[0][j].y()) / dir.y();
                    if (!(t >= 0.0) || !(t <= 1.0)) continue;
                    points.add(new Point2D(vertices[0][j].x() + dir.x() * t, vertices[0][j].z() + dir.z() * t));
                }
            }
            pos.setY(y);
            RiftPlacementHelper.iterate2D(points, (x, z) -> {
                pos.setX(x.intValue());
                pos.setZ(z.intValue());
                effect.accept((BlockPos)pos);
            });
        }
    }

    private static void iterate2D(List<Point2D> points, BiConsumer<Integer, Integer> effect) {
        if (points.isEmpty()) {
            return;
        }
        if (points.size() == 1) {
            Point2D point = points.getFirst();
            effect.accept(Mth.floor((double)point.x()), Mth.floor((double)point.y()));
            return;
        }
        ArrayList<Pair> lines = new ArrayList<Pair>();
        for (int i = 0; i < points.size() - 1; ++i) {
            for (int j = i + 1; j < points.size(); ++j) {
                lines.add(Pair.of((Object)points.get(i), (Object)points.get(j)));
            }
        }
        double[] xVals = points.stream().mapToDouble(Point2D::x).sorted().toArray();
        int i = 0;
        int x = Mth.floor((double)xVals[0]);
        while ((double)x <= xVals[xVals.length - 1]) {
            ArrayList<Double> crit = new ArrayList<Double>();
            if ((double)x >= xVals[0]) {
                crit.add(Double.valueOf(x));
            }
            int high = x + 1;
            while (i < xVals.length && xVals[i] < (double)high) {
                if (crit.isEmpty() || (Double)crit.getLast() != xVals[i]) {
                    crit.add(xVals[i]);
                }
                ++i;
            }
            if ((double)high <= xVals[xVals.length - 1] && (crit.isEmpty() || (Double)crit.getLast() != (double)high)) {
                crit.add(Double.valueOf(high));
            }
            boolean found = false;
            double min = Double.MAX_VALUE;
            double max = -1.7976931348623157E308;
            for (Pair line : lines) {
                Iterator iterator = crit.iterator();
                while (iterator.hasNext()) {
                    double yMax;
                    double yMin;
                    double val = (Double)iterator.next();
                    Point2D from = (Point2D)line.getFirst();
                    Point2D to = (Point2D)line.getSecond();
                    if (!(Math.min(from.x(), to.x()) <= val) || !(Math.max(from.x(), to.x()) >= val)) continue;
                    double dif = to.x() - from.x();
                    if (dif == 0.0) {
                        yMin = Math.min(from.y(), to.y());
                        yMax = Math.max(from.y(), to.y());
                    } else {
                        double slope = (to.y() - from.y()) / dif;
                        yMin = yMax = from.y() + slope * (val - from.x());
                    }
                    if (yMin < min) {
                        min = yMin;
                    }
                    if (yMax > max) {
                        max = yMax;
                    }
                    found = true;
                }
            }
            if (found) {
                int y = Mth.floor((double)min);
                while ((double)y <= max) {
                    effect.accept(x, y);
                    ++y;
                }
            }
            ++x;
        }
    }

    private static Vec3[] calculateSectionPolygon(Vec3[][] vertices, Vec3 normal, AABB bounds) {
        HashSet<Vec3> points = new HashSet<Vec3>();
        for (int i = 0; i < vertices[0].length; ++i) {
            if (RiftPlacementHelper.containsInclusive(vertices[0][i], bounds)) {
                points.add(vertices[0][i]);
            }
            bounds.clip(vertices[0][i], vertices[1][i]).ifPresent(points::add);
            bounds.clip(vertices[1][i], vertices[0][i]).ifPresent(points::add);
        }
        for (Vec3[] line : RiftPlacementHelper.getLines(bounds)) {
            points.addAll(Arrays.asList(RiftPlacementHelper.intersection(vertices, normal, line[0], line[1])));
        }
        if (points.isEmpty()) {
            return new Vec3[0];
        }
        Vec3[] out = (Vec3[])points.toArray(Vec3[]::new);
        RiftPlacementHelper.reorderConvex(out, normal);
        return out;
    }

    private static Vec3[] intersection(Vec3[][] vertices, Vec3 normal, Vec3 from, Vec3 to) {
        Vec3 intersection;
        if (vertices.length == 0) {
            return new Vec3[0];
        }
        Vec3 dir = to.subtract(from);
        double dot = normal.dot(dir);
        if (dot == 0.0) {
            double dist;
            Vec3[] all;
            int i;
            double lowDist;
            Vec3 closest;
            if (normal.dot(vertices[0][0]) != normal.dot(from)) {
                return new Vec3[0];
            }
            ArrayList<Vec3> points = new ArrayList<Vec3>();
            if (RiftPlacementHelper.isCoplanarPointInside(vertices[0], from)) {
                points.add(from);
            } else {
                closest = null;
                lowDist = Double.MAX_VALUE;
                for (i = 0; i < vertices[0].length; ++i) {
                    for (Vec3 intersection2 : all = RiftPlacementHelper.getCoplanarIntersection(vertices[0][i], vertices[1][i], from, to)) {
                        dist = intersection2.distanceToSqr(from);
                        if (!(dist <= lowDist)) continue;
                        closest = intersection2;
                        lowDist = dist;
                    }
                }
                if (closest != null) {
                    points.add(closest);
                }
            }
            if (RiftPlacementHelper.isCoplanarPointInside(vertices[0], to)) {
                points.add(to);
            } else {
                closest = null;
                lowDist = Double.MAX_VALUE;
                for (i = 0; i < vertices[0].length; ++i) {
                    for (Vec3 intersection2 : all = RiftPlacementHelper.getCoplanarIntersection(vertices[0][i], vertices[1][i], to, from)) {
                        dist = intersection2.distanceToSqr(to);
                        if (!(dist <= lowDist)) continue;
                        closest = intersection2;
                        lowDist = dist;
                    }
                }
                if (closest != null) {
                    points.add(closest);
                }
            }
            return (Vec3[])points.toArray(Vec3[]::new);
        }
        double t = (normal.dot(vertices[0][0]) - normal.dot(from)) / dot;
        if (t >= 0.0 && t <= 1.0 && RiftPlacementHelper.isCoplanarPointInside(vertices[0], intersection = from.add(dir.scale(t)))) {
            return new Vec3[]{intersection};
        }
        return new Vec3[0];
    }

    private static Vec3[] getCoplanarIntersection(Vec3 start1, Vec3 end1, Vec3 start2, Vec3 end2) {
        Vec3 dir1 = end1.subtract(start1);
        Vec3 dir2 = end2.subtract(start2);
        double len1 = dir1.lengthSqr();
        double len2 = dir2.lengthSqr();
        if (len1 == 0.0 && len2 == 0.0) {
            Vec3[] vec3Array;
            if (start1.equals((Object)start2)) {
                Vec3[] vec3Array2 = new Vec3[1];
                vec3Array = vec3Array2;
                vec3Array2[0] = start1;
            } else {
                vec3Array = new Vec3[]{};
            }
            return vec3Array;
        }
        if (len1 == 0.0) {
            Vec3[] vec3Array;
            if (RiftPlacementHelper.isPointOnLine(start1, start2, end2)) {
                Vec3[] vec3Array3 = new Vec3[1];
                vec3Array = vec3Array3;
                vec3Array3[0] = start1;
            } else {
                vec3Array = new Vec3[]{};
            }
            return vec3Array;
        }
        if (len2 == 0.0) {
            Vec3[] vec3Array;
            if (RiftPlacementHelper.isPointOnLine(start2, start1, end1)) {
                Vec3[] vec3Array4 = new Vec3[1];
                vec3Array = vec3Array4;
                vec3Array4[0] = start2;
            } else {
                vec3Array = new Vec3[]{};
            }
            return vec3Array;
        }
        double dot = dir2.dot(dir1);
        double dif = len1 * len2 - dot * dot;
        if (dif == 0.0) {
            ArrayList<Vec3> valid = new ArrayList<Vec3>();
            if (RiftPlacementHelper.isPointOnLine(start1, start2, end2)) {
                valid.add(start1);
            }
            if (RiftPlacementHelper.isPointOnLine(start2, start2, end2)) {
                valid.add(start2);
            }
            if (RiftPlacementHelper.isPointOnLine(end1, start1, end1)) {
                valid.add(end1);
            }
            if (RiftPlacementHelper.isPointOnLine(end2, start1, end1)) {
                valid.add(end2);
            }
            switch (valid.size()) {
                case 0: {
                    return new Vec3[0];
                }
                case 1: {
                    return new Vec3[]{(Vec3)valid.get(0)};
                }
                case 2: {
                    Vec3[] vec3Array;
                    if (((Vec3)valid.get(0)).equals(valid.get(1))) {
                        Vec3[] vec3Array5 = new Vec3[1];
                        vec3Array = vec3Array5;
                        vec3Array5[0] = (Vec3)valid.get(0);
                    } else {
                        Vec3[] vec3Array6 = new Vec3[2];
                        vec3Array6[0] = (Vec3)valid.get(0);
                        vec3Array = vec3Array6;
                        vec3Array6[1] = (Vec3)valid.get(1);
                    }
                    return vec3Array;
                }
            }
            Vec3[] longest = new Vec3[2];
            double maxDist = 0.0;
            for (int i = 0; i < valid.size() - 1; ++i) {
                for (int j = i + 1; j < valid.size(); ++j) {
                    Vec3 p2;
                    Vec3 p1 = (Vec3)valid.get(i);
                    double dist = p1.distanceToSqr(p2 = (Vec3)valid.get(j));
                    if (!(dist >= maxDist)) continue;
                    longest[0] = p1;
                    longest[1] = p2;
                    maxDist = dist;
                }
            }
            return longest;
        }
        double start2Dot = start1.subtract(start2).dot(end2.subtract(start2));
        double start1Dot = start1.subtract(start2).dot(end1.subtract(start1));
        double factorA = (start2Dot * dot - start1Dot * len2) / dif;
        double factorB = (start2Dot + factorA * dot) / len2;
        if (factorA > 1.0 || factorA < 0.0 || factorB > 1.0 || factorB < 0.0) {
            return new Vec3[0];
        }
        return new Vec3[]{start1.add(dir1.scale(factorA))};
    }

    private static boolean isCoplanarPointInside(Vec3[] vertices, Vec3 point) {
        if (vertices.length == 0) {
            return false;
        }
        if (vertices.length == 1) {
            return vertices[0].equals((Object)point);
        }
        Vec3[] v = new Vec3[vertices.length];
        for (int i = 0; i < v.length; ++i) {
            v[i] = vertices[i].subtract(point);
        }
        Vec3 base = v[v.length - 1].cross(v[0]);
        for (int i = 1; i < v.length; ++i) {
            Vec3 cross = v[i - 1].cross(v[i]);
            if (base.dot(cross) < 0.0) {
                return false;
            }
            base = cross;
        }
        return true;
    }

    private static boolean isPointOnLine(Vec3 point, Vec3 start, Vec3 end) {
        Vec3 dir = end.subtract(start);
        double len = dir.lengthSqr();
        if (len == 0.0) {
            return start.equals((Object)point);
        }
        double factor = (point.dot(dir) - start.dot(dir)) / len;
        Vec3 intersection = start.add(dir.scale(factor));
        return factor >= 0.0 && factor <= 1.0 && point.equals((Object)intersection);
    }

    private static boolean containsInclusive(Vec3 point, AABB bounds) {
        return point.x() >= bounds.minX && point.x() <= bounds.maxX && point.y() >= bounds.minY && point.y() <= bounds.maxY && point.z() >= bounds.minZ && point.z() <= bounds.maxZ;
    }

    private static void reorderConvex(Vec3[] points, Vec3 normal) {
        if (points.length <= 1) {
            return;
        }
        Vec3 n = normal.normalize();
        Vec3 center = Arrays.stream(points).reduce(Vec3.ZERO, Vec3::add).scale(1.0 / (double)points.length);
        Vec3 dir = points[0].subtract(center).normalize();
        Arrays.sort(points, (p1, p2) -> {
            Vec3 v1 = p1.subtract(center).normalize();
            Vec3 v2 = p2.subtract(center).normalize();
            double x1 = v1.dot(dir);
            double x2 = v2.dot(dir);
            double y1 = v1.cross(dir).dot(n);
            double y2 = v2.cross(dir).dot(n);
            if (y1 == 0.0) {
                if (y2 == 0.0) {
                    if (x1 >= 0.0) {
                        return x2 >= 0.0 ? 0 : -1;
                    }
                    return x2 >= 0.0 ? 1 : 0;
                }
                if (x1 >= 0.0) {
                    return -1;
                }
                return y2 < 0.0 ? -1 : 1;
            }
            if (y2 == 0.0) {
                if (x2 >= 0.0) {
                    return 1;
                }
                return y1 < 0.0 ? 1 : -1;
            }
            if (x1 == 0.0) {
                if (x2 == 0.0) {
                    if (y1 < 0.0) {
                        return y2 < 0.0 ? 0 : 1;
                    }
                    return y2 < 0.0 ? -1 : 0;
                }
                if (x2 < 0.0) {
                    return y1 < 0.0 ? 1 : -1;
                }
                return y2 < 0.0 ? -1 : 1;
            }
            if (x2 == 0.0) {
                if (x1 < 0.0) {
                    return y2 < 0.0 ? -1 : 1;
                }
                return y1 < 0.0 ? 1 : -1;
            }
            int slope = Double.compare(y1 * x2, y2 * x1);
            if (y1 > 0.0) {
                if (y2 > 0.0) {
                    if (x1 * x2 > 0.0) {
                        return slope;
                    }
                    if (x1 < 0.0) {
                        return 1;
                    }
                }
                return -1;
            }
            if (y2 > 0.0) {
                return 1;
            }
            if (x1 * x2 > 0.0) {
                return slope;
            }
            if (x1 < 0.0) {
                return -1;
            }
            return 1;
        });
    }

    public static boolean intersects(Vec3[][] points, Vec3 normal, AABB bounds) {
        for (Vec3 vec3 : points[0]) {
            if (!RiftPlacementHelper.containsInclusive(vec3, bounds)) continue;
            return true;
        }
        for (Vec3 vec3 : RiftPlacementHelper.getLines(bounds)) {
            if (RiftPlacementHelper.intersection(points, normal, vec3[0], vec3[1]).length == 0) continue;
            return true;
        }
        return false;
    }

    private static Vec3[][] getLines(AABB bounds) {
        return new Vec3[][]{{new Vec3(bounds.minX, bounds.minY, bounds.minZ), new Vec3(bounds.maxX, bounds.minY, bounds.minZ)}, {new Vec3(bounds.minX, bounds.minY, bounds.maxZ), new Vec3(bounds.maxX, bounds.minY, bounds.maxZ)}, {new Vec3(bounds.minX, bounds.maxY, bounds.minZ), new Vec3(bounds.maxX, bounds.maxY, bounds.minZ)}, {new Vec3(bounds.minX, bounds.maxY, bounds.maxZ), new Vec3(bounds.maxX, bounds.maxY, bounds.maxZ)}, {new Vec3(bounds.minX, bounds.minY, bounds.minZ), new Vec3(bounds.minX, bounds.maxY, bounds.minZ)}, {new Vec3(bounds.minX, bounds.minY, bounds.maxZ), new Vec3(bounds.minX, bounds.maxY, bounds.maxZ)}, {new Vec3(bounds.maxX, bounds.minY, bounds.minZ), new Vec3(bounds.maxX, bounds.maxY, bounds.minZ)}, {new Vec3(bounds.maxX, bounds.minY, bounds.maxZ), new Vec3(bounds.maxX, bounds.maxY, bounds.maxZ)}, {new Vec3(bounds.minX, bounds.minY, bounds.minZ), new Vec3(bounds.minX, bounds.minY, bounds.maxZ)}, {new Vec3(bounds.minX, bounds.maxY, bounds.minZ), new Vec3(bounds.minX, bounds.maxY, bounds.maxZ)}, {new Vec3(bounds.maxX, bounds.minY, bounds.minZ), new Vec3(bounds.maxX, bounds.minY, bounds.maxZ)}, {new Vec3(bounds.maxX, bounds.maxY, bounds.minZ), new Vec3(bounds.maxX, bounds.maxY, bounds.maxZ)}};
    }

    public static enum ReplacementType {
        DESTROY((world, pos, state) -> state.getDestroySpeed((BlockGetter)world, pos) != -1.0f, true),
        FEATURE_REMOVE((world, pos, state) -> REPLACE.test(state), false),
        NONE((world, pos, state) -> state.isAir(), false);

        private final ReplacementPolicy policy;
        private final boolean drop;

        private ReplacementType(ReplacementPolicy policy, boolean drop) {
            this.policy = policy;
            this.drop = drop;
        }

        public boolean canReplace(LevelReader world, BlockPos pos, BlockState state) {
            return this.policy.canReplace(world, pos, state);
        }

        public boolean hasDrops() {
            return this.drop;
        }
    }

    private record Point2D(double x, double y) {
    }

    @FunctionalInterface
    private static interface ReplacementPolicy {
        public boolean canReplace(LevelReader var1, BlockPos var2, BlockState var3);
    }
}

