/*
 * Decompiled with CFR 0.152.
 */
package io.github.davidqf555.minecraft.multiverse.common.world.blocks;

import io.github.davidqf555.minecraft.multiverse.client.ClientConfigs;
import io.github.davidqf555.minecraft.multiverse.common.util.TagUtil;
import io.github.davidqf555.minecraft.multiverse.common.world.RiftPlacementHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public record RiftPlacement(Vec3 center, double width, double height, Vec3 normal, float angle) {
    @Nullable
    public static RiftPlacement deserialize(CompoundTag tag) {
        if (tag.contains("Center", 10) && tag.contains("Width", 6) && tag.contains("Height", 6) && tag.contains("Normal", 10) && tag.contains("Angle", 5)) {
            Vec3 center = TagUtil.readVec(tag.getCompound("Center"));
            if (center == null) {
                return null;
            }
            Vec3 normal = TagUtil.readVec(tag.getCompound("Normal"));
            if (normal == null) {
                return null;
            }
            if ((normal = normal.normalize()).lengthSqr() == 0.0) {
                normal = new Vec3(0.0, 1.0, 0.0);
            }
            double width = tag.getDouble("Width");
            double height = tag.getDouble("Height");
            float angle = tag.getFloat("Angle");
            return new RiftPlacement(center, width, height, normal, angle);
        }
        return null;
    }

    private static double getSizeFactor(int layer, int layers) {
        if (layers <= 1) {
            return 1.0;
        }
        double rate = (Double)ClientConfigs.INSTANCE.riftLayerGrowth.get();
        double start = (Double)ClientConfigs.INSTANCE.riftLayerStart.get();
        double denom = 1.0 - Math.pow(rate, layers - 1);
        if (denom == 0.0) {
            return Mth.lerp((double)((double)layer / ((double)layers - 1.0)), (double)start, (double)1.0);
        }
        double inter = (1.0 - start * Math.pow(rate, layers - 1)) / denom;
        return (start - inter) * Math.pow(rate, layer) + inter;
    }

    public Vec3[][] calculateLayers(BlockPos pos) {
        int layers = (Integer)ClientConfigs.INSTANCE.riftLayers.get();
        Vec3[][] out = new Vec3[layers][];
        for (int i = 0; i < layers; ++i) {
            double factor = RiftPlacement.getSizeFactor(i, layers);
            RiftPlacement child = new RiftPlacement(this.center(), this.width() * factor, this.height() * factor, this.normal(), this.angle());
            out[i] = RiftPlacementHelper.calculateVerticesAt(child, pos);
        }
        return out;
    }

    public CompoundTag serialize() {
        CompoundTag tag = new CompoundTag();
        tag.put("Center", (Tag)TagUtil.writeVec(this.center()));
        tag.putDouble("Width", this.width());
        tag.putDouble("Height", this.height());
        tag.put("Normal", (Tag)TagUtil.writeVec(this.normal()));
        tag.putFloat("Angle", this.angle());
        return tag;
    }
}

