/*
 * Decompiled with CFR 0.152.
 */
package io.github.davidqf555.minecraft.multiverse.common.world.entities;

import io.github.davidqf555.minecraft.multiverse.common.world.RiftHelper;
import io.github.davidqf555.minecraft.multiverse.common.world.blocks.RiftBlock;
import io.github.davidqf555.minecraft.multiverse.registration.EntityRegistry;
import io.github.davidqf555.minecraft.multiverse.registration.ItemRegistry;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;

@ParametersAreNonnullByDefault
public class KaleiditeCoreEntity
extends ThrowableItemProjectile {
    public KaleiditeCoreEntity(EntityType<? extends KaleiditeCoreEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public KaleiditeCoreEntity(EntityType<? extends KaleiditeCoreEntity> pEntityType, LivingEntity owner, Level pLevel, ItemStack item) {
        super(pEntityType, owner, pLevel, item);
    }

    public KaleiditeCoreEntity(LivingEntity owner, Level pLevel, ItemStack item) {
        this((EntityType<? extends KaleiditeCoreEntity>)((EntityType)EntityRegistry.KALEIDITE_CORE.get()), owner, pLevel, item);
    }

    public KaleiditeCoreEntity(EntityType<? extends KaleiditeCoreEntity> type, double x, double y, double z, Level world, ItemStack item) {
        super(type, x, y, z, world, item);
    }

    public KaleiditeCoreEntity(double x, double y, double z, Level world, ItemStack item) {
        this((EntityType<? extends KaleiditeCoreEntity>)((EntityType)EntityRegistry.KALEIDITE_CORE.get()), x, y, z, world, item);
    }

    @Nonnull
    protected Item getDefaultItem() {
        return (Item)ItemRegistry.KALEIDITE_CORE.get();
    }

    public void tick() {
        BlockPos pos = this.blockPosition();
        if (!this.level().isClientSide() && this.isAlive() && this.level().getBlockState(pos).getBlock() instanceof RiftBlock) {
            RiftHelper.destroyRift((ServerLevel)this.level(), pos, (Entity)this);
            this.discard();
        }
        super.tick();
    }

    protected void onHit(HitResult pResult) {
        super.onHit(pResult);
        if (this.level() instanceof ServerLevel && this.isAlive()) {
            Entity owner = this.getOwner();
            RiftHelper.placeRandomRift((ServerLevel)this.level(), false, this.position(), owner instanceof Mob);
            this.discard();
        }
    }
}

