/*
 * Decompiled with CFR 0.152.
 */
package io.github.davidqf555.minecraft.multiverse.common.world.entities.ai;

import java.util.EnumSet;
import java.util.function.Function;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;

public class EntityHurtTargetGoal<T extends Mob>
extends TargetGoal {
    private final T mob;
    private final Function<T, LivingEntity> target;
    private LivingEntity lastHurt;
    private int timestamp;

    public EntityHurtTargetGoal(T mob, Function<T, LivingEntity> target) {
        super(mob, false);
        this.mob = mob;
        this.target = target;
        this.setFlags(EnumSet.of(Goal.Flag.TARGET));
    }

    public boolean canUse() {
        LivingEntity target = this.target.apply(this.mob);
        if (target == null) {
            return false;
        }
        this.lastHurt = target.getLastHurtMob();
        int i = target.getLastHurtMobTimestamp();
        return i != this.timestamp && this.canAttack(this.lastHurt, TargetingConditions.DEFAULT);
    }

    public void start() {
        this.mob.setTarget(this.lastHurt);
        LivingEntity target = this.target.apply(this.mob);
        if (target != null) {
            this.timestamp = target.getLastHurtMobTimestamp();
        }
        super.start();
    }
}

