/*
 * Decompiled with CFR 0.152.
 */
package io.github.davidqf555.minecraft.multiverse.common.world.entities.ai;

import java.util.EnumSet;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.AirRandomPos;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.phys.Vec3;

public class FlyingPathfindToRaidGoal
extends Goal {
    private final Raider mob;
    private final double speed;

    public FlyingPathfindToRaidGoal(Raider mob, double speed) {
        this.mob = mob;
        this.speed = speed;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean canUse() {
        return this.mob.getTarget() == null && !this.mob.isVehicle() && this.mob.hasActiveRaid() && !this.mob.getCurrentRaid().isOver() && !((ServerLevel)this.mob.level()).isVillage(this.mob.blockPosition());
    }

    public boolean canContinueToUse() {
        return this.mob.hasActiveRaid() && !this.mob.getCurrentRaid().isOver() && this.mob.level() instanceof ServerLevel && !((ServerLevel)this.mob.level()).isVillage(this.mob.blockPosition());
    }

    public void tick() {
        if (this.mob.hasActiveRaid()) {
            Raid raid = this.mob.getCurrentRaid();
            if (!this.mob.isPathFinding()) {
                Vec3 target = Vec3.atBottomCenterOf((Vec3i)raid.getCenter());
                int pY = 0;
                if (target.y() - this.mob.getY() > 2.0) {
                    pY = 3;
                } else if (target.y() - this.mob.getY() < -2.0) {
                    pY = -3;
                }
                Vec3 pos = AirRandomPos.getPosTowards((PathfinderMob)this.mob, (int)15, (int)4, (int)pY, (Vec3)target, (double)1.5707963267948966);
                if (pos != null) {
                    this.mob.getNavigation().moveTo(pos.x(), pos.y(), pos.z(), this.speed);
                }
            }
        }
    }
}

