/*
 * Decompiled with CFR 0.152.
 */
package io.github.davidqf555.minecraft.multiverse.common.world.entities.ai;

import java.util.EnumSet;
import java.util.function.Function;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;

public class FollowEntityGoal<T extends Mob>
extends Goal {
    private final T mob;
    private final double start;
    private final double stop;
    private final float speed;
    private final Function<T, Entity> targetMap;
    private int recalculate;
    private Entity target;

    public FollowEntityGoal(T mob, Function<T, Entity> targetMap, double start, double stop, float speed) {
        this.mob = mob;
        this.targetMap = targetMap;
        this.speed = speed;
        this.start = start;
        this.stop = stop;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        Entity target = this.targetMap.apply(this.mob);
        if (target == null || target.isSpectator() || this.mob.distanceToSqr(target) < this.start * this.start) {
            return false;
        }
        this.target = target;
        return true;
    }

    public boolean canContinueToUse() {
        if (this.mob.getNavigation().isDone()) {
            return false;
        }
        return this.mob.distanceToSqr(this.target) > this.stop * this.stop;
    }

    public void start() {
        this.recalculate = 0;
    }

    public void stop() {
        this.target = null;
        this.mob.getNavigation().stop();
    }

    public void tick() {
        this.mob.getLookControl().setLookAt(this.target, 10.0f, (float)this.mob.getMaxHeadXRot());
        if (--this.recalculate <= 0) {
            this.recalculate = 10;
            if (!this.mob.isPassenger()) {
                this.mob.getNavigation().moveTo(this.target, (double)this.speed);
            }
        }
    }
}

