/*
 * Decompiled with CFR 0.152.
 */
package io.github.davidqf555.minecraft.multiverse.common.world.items;

import io.github.davidqf555.minecraft.multiverse.common.packets.RiftParticlesPacket;
import io.github.davidqf555.minecraft.multiverse.common.world.DimensionHelper;
import io.github.davidqf555.minecraft.multiverse.registration.DataComponentTypeRegistry;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;

public final class MultiversalToolHelper {
    public static final Component LORE = Component.translatable((String)Util.makeDescriptionId((String)"item", (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"multiverse", (String)"multiversal_lore"))).withStyle(ChatFormatting.GOLD);
    public static final Component CROUCH_INSTRUCTIONS = Component.translatable((String)Util.makeDescriptionId((String)"item", (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"multiverse", (String)"multiversal_crouch_instructions"))).withStyle(ChatFormatting.AQUA);
    public static final Component INSTRUCTIONS = Component.translatable((String)Util.makeDescriptionId((String)"item", (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"multiverse", (String)"multiversal_instructions"))).withStyle(ChatFormatting.AQUA);

    private MultiversalToolHelper() {
    }

    public static ResourceKey<Level> getTarget(ItemStack stack) {
        return (ResourceKey)stack.getOrDefault((DataComponentType)DataComponentTypeRegistry.TARGET.get(), (Object)Level.OVERWORLD);
    }

    public static boolean setTarget(ItemStack stack, ResourceKey<Level> target) {
        if (!MultiversalToolHelper.getTarget(stack).equals(target)) {
            stack.set((DataComponentType)DataComponentTypeRegistry.TARGET.get(), target);
            return true;
        }
        return false;
    }

    public static void setRandomTarget(Level world, ItemStack stack) {
        ResourceKey<Level> current = MultiversalToolHelper.getTarget(stack);
        ResourceKey<Level> target = DimensionHelper.randomMultiverseDimension(world.getRandom(), Optional.of(current));
        MultiversalToolHelper.setTarget(stack, target);
    }

    public static boolean setCurrent(Level world, ItemStack stack) {
        return MultiversalToolHelper.setTarget(stack, (ResourceKey<Level>)world.dimension());
    }

    public static void mineBlock(Player entity, ServerLevel world, ItemStack stack, BlockPos pos) {
        BlockPos block;
        BlockState s;
        ServerLevel w;
        ResourceKey current;
        ResourceKey<Level> target = MultiversalToolHelper.getTarget(stack);
        if (target != (current = world.dimension()) && (w = world.getServer().getLevel(target)) != null && MultiversalToolHelper.isBreakable((Level)w, s = w.getBlockState(block = BlockPos.containing((Position)DimensionHelper.translate(Vec3.atCenterOf((Vec3i)pos), world.dimensionType(), w.dimensionType(), false))), block) && w.destroyBlock(block, false, (Entity)entity)) {
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)w, (ChunkPos)new ChunkPos(block), (CustomPacketPayload)new RiftParticlesPacket(Optional.of(current), Vec3.atCenterOf((Vec3i)block)), (CustomPacketPayload[])new CustomPacketPayload[0]);
            w.playSound(null, (double)block.getX() + 0.5, (double)block.getY() + 0.5, (double)block.getZ() + 0.5, SoundEvents.ENDERMAN_TELEPORT, SoundSource.BLOCKS, 1.0f, 1.0f);
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)world, (ChunkPos)new ChunkPos(pos), (CustomPacketPayload)new RiftParticlesPacket(Optional.of(current), Vec3.atCenterOf((Vec3i)pos)), (CustomPacketPayload[])new CustomPacketPayload[0]);
            world.playSound(null, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, SoundEvents.ENDERMAN_TELEPORT, SoundSource.BLOCKS, 1.0f, 1.0f);
            Block.dropResources((BlockState)s, (Level)world, (BlockPos)pos, (BlockEntity)w.getBlockEntity(block), (Entity)entity, (ItemStack)stack);
        }
    }

    private static boolean isBreakable(Level world, BlockState state, BlockPos pos) {
        return !state.isAir() && state.getFluidState().isEmpty() && state.getDestroySpeed((BlockGetter)world, pos) != -1.0f;
    }
}

