/*
 * Decompiled with CFR 0.152.
 */
package io.github.davidqf555.minecraft.multiverse.common.world.items;

import io.github.davidqf555.minecraft.multiverse.common.ServerConfigs;
import io.github.davidqf555.minecraft.multiverse.common.world.RiftHelper;
import io.github.davidqf555.minecraft.multiverse.common.world.RiftPlacementHelper;
import io.github.davidqf555.minecraft.multiverse.common.world.items.MultiversalToolHelper;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.ToolMaterial;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class RiftSwordItem
extends SwordItem {
    public RiftSwordItem(ToolMaterial tier, float damage, float speed, Item.Properties properties) {
        super(tier, damage, speed, properties);
    }

    public static void slash(ServerLevel level, Vec3 start, Vec3 look, double dist, double width, double height, float angle, ResourceKey<Level> target) {
        look = look.normalize();
        Vec3 center = start.add(look.scale(dist));
        RiftHelper.placeRandomRift(level, target, true, width, height, center, look, angle, RiftPlacementHelper.ReplacementType.DESTROY);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> text, TooltipFlag flag) {
        super.appendHoverText(stack, context, text, flag);
        text.add(MultiversalToolHelper.CROUCH_INSTRUCTIONS);
    }

    public boolean releaseUsing(ItemStack stack, Level world, LivingEntity entity, int remaining) {
        int duration;
        if (world instanceof ServerLevel && (duration = this.getUseDuration(stack, entity) - remaining - (Integer)ServerConfigs.INSTANCE.swordMinCharge.get()) >= 0) {
            double width = Math.min((Double)ServerConfigs.INSTANCE.swordMinWidth.get() + (Double)ServerConfigs.INSTANCE.swordWidthRate.get() * (double)duration, (Double)ServerConfigs.INSTANCE.swordMaxWidth.get());
            double height = Math.min((Double)ServerConfigs.INSTANCE.swordMinHeight.get() + (Double)ServerConfigs.INSTANCE.swordHeightRate.get() * (double)duration, (Double)ServerConfigs.INSTANCE.swordMaxHeight.get());
            HumanoidArm used = entity.getMainArm();
            if (entity.getUsedItemHand() == InteractionHand.OFF_HAND) {
                used = used.getOpposite();
            }
            float angle = used == HumanoidArm.RIGHT ? 45.0f : -45.0f;
            Vec3 look = entity.getLookAngle();
            Vec3 start = entity.getEyePosition();
            RiftSwordItem.slash((ServerLevel)world, start, look, (Double)ServerConfigs.INSTANCE.swordSpawnDistance.get(), width, height, angle, MultiversalToolHelper.getTarget(stack));
            if (entity instanceof Player && !((Player)entity).isCreative()) {
                ((Player)entity).getCooldowns().addCooldown(stack, ((Integer)ServerConfigs.INSTANCE.swordCooldown.get()).intValue());
            }
            return true;
        }
        return false;
    }

    public int getUseDuration(ItemStack stack, LivingEntity user) {
        return 72000;
    }

    public ItemUseAnimation getUseAnimation(ItemStack stack) {
        return ItemUseAnimation.BOW;
    }

    public InteractionResult use(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (player.isShiftKeyDown()) {
            if (!world.isClientSide()) {
                MultiversalToolHelper.setRandomTarget(world, stack);
            }
        } else {
            if (MultiversalToolHelper.getTarget(stack).equals((Object)world.dimension())) {
                return InteractionResult.PASS;
            }
            player.startUsingItem(hand);
        }
        return InteractionResult.CONSUME;
    }
}

