/*
 * Decompiled with CFR 0.152.
 */
package io.github.davidqf555.minecraft.multiverse.common.world.items;

import io.github.davidqf555.minecraft.multiverse.common.ServerConfigs;
import io.github.davidqf555.minecraft.multiverse.common.packets.RiftParticlesPacket;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;

public class WarpShieldItem
extends ShieldItem {
    public WarpShieldItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public void onUseTick(Level world, LivingEntity player, ItemStack stack, int count) {
        if (!world.isClientSide()) {
            double range = (Double)ServerConfigs.INSTANCE.shieldRange.get();
            AABB bounds = AABB.ofSize((Vec3)player.getEyePosition(), (double)(range * 2.0), (double)(range * 2.0), (double)(range * 2.0));
            for (Projectile proj : world.getEntitiesOfClass(Projectile.class, bounds)) {
                PacketDistributor.sendToPlayersTrackingEntity((Entity)proj, (CustomPacketPayload)new RiftParticlesPacket(Optional.empty(), proj.position()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                proj.discard();
            }
        }
    }

    public Component getName(ItemStack stack) {
        return (Component)stack.getComponents().getOrDefault(DataComponents.ITEM_NAME, (Object)CommonComponents.EMPTY);
    }

    public void appendHoverText(ItemStack p_43094_, Item.TooltipContext p_339613_, List<Component> p_43096_, TooltipFlag p_43097_) {
    }
}

