/*
 * Decompiled with CFR 0.152.
 */
package io.github.davidqf555.minecraft.multiverse.common.world.items;

import io.github.davidqf555.minecraft.multiverse.common.ServerConfigs;
import io.github.davidqf555.minecraft.multiverse.common.world.WarpTeleporter;
import io.github.davidqf555.minecraft.multiverse.common.world.items.MultiversalToolHelper;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class WarpToolItem
extends Item {
    private static final Component INSTRUCTIONS = Component.translatable((String)(Util.makeDescriptionId((String)"item", (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"multiverse", (String)"warp_ring")) + ".instructions")).withStyle(ChatFormatting.AQUA);

    public WarpToolItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> text, TooltipFlag flag) {
        super.appendHoverText(stack, context, text, flag);
        text.add(INSTRUCTIONS);
    }

    public InteractionResult use(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (player.isShiftKeyDown()) {
            if (!MultiversalToolHelper.setCurrent(world, stack)) {
                return InteractionResult.PASS;
            }
        } else if (world instanceof ServerLevel) {
            ResourceKey current = world.dimension();
            ResourceKey<Level> target = MultiversalToolHelper.getTarget(stack);
            Entity copy = WarpTeleporter.warp((Entity)player, target);
            if (copy != null) {
                MultiversalToolHelper.setTarget(stack, (ResourceKey<Level>)current);
                if (!player.isCreative()) {
                    player.getCooldowns().addCooldown(stack, ((Integer)ServerConfigs.INSTANCE.warpRingCooldown.get()).intValue());
                }
            }
        }
        return InteractionResult.CONSUME;
    }
}

