/*
 * Decompiled with CFR 0.152.
 */
package io.github.davidqf555.minecraft.multiverse.common.world.worldgen;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.davidqf555.minecraft.multiverse.common.util.MultiverseConfig;
import io.github.davidqf555.minecraft.multiverse.common.world.worldgen.MultiverseType;
import java.util.function.Supplier;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.world.level.levelgen.SurfaceRules;

public class LazyMultiverseSurfaceRuleSource
implements SurfaceRules.RuleSource {
    public static final MapCodec<LazyMultiverseSurfaceRuleSource> DIRECT = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Codec.BOOL.fieldOf("floor").forGetter(source -> source.floor), (App)Codec.BOOL.fieldOf("ceiling").forGetter(source -> source.ceiling), (App)MultiverseType.CODEC.fieldOf("multiverse_type").forGetter(source -> source.type)).apply((Applicative)inst, LazyMultiverseSurfaceRuleSource::new));
    public static final KeyDispatchDataCodec<LazyMultiverseSurfaceRuleSource> CODEC = KeyDispatchDataCodec.of(DIRECT);
    private final boolean floor;
    private final boolean ceiling;
    private final MultiverseType type;
    private final Supplier<SurfaceRules.RuleSource> rule;

    public LazyMultiverseSurfaceRuleSource(boolean floor, boolean ceiling, MultiverseType type) {
        this.floor = floor;
        this.ceiling = ceiling;
        this.type = type;
        this.rule = Suppliers.memoize(() -> MultiverseConfig.getBiomesManager().createSurface(floor, ceiling, type));
    }

    public SurfaceRules.SurfaceRule apply(SurfaceRules.Context context) {
        return (SurfaceRules.SurfaceRule)this.rule.get().apply((Object)context);
    }

    public KeyDispatchDataCodec<? extends SurfaceRules.RuleSource> codec() {
        return CODEC;
    }
}

