/*
 * Decompiled with CFR 0.152.
 */
package io.github.davidqf555.minecraft.multiverse.common.world.worldgen.biomes;

import com.google.common.collect.ImmutableSet;
import io.github.davidqf555.minecraft.multiverse.common.world.worldgen.MultiverseSurfaceRuleData;
import io.github.davidqf555.minecraft.multiverse.common.world.worldgen.MultiverseType;
import io.github.davidqf555.minecraft.multiverse.common.world.worldgen.biomes.MultiverseBiomes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.OverworldBiomeBuilder;
import net.minecraft.world.level.levelgen.SurfaceRules;

public class VanillaMultiverseBiomes
implements MultiverseBiomes {
    public static final VanillaMultiverseBiomes INSTANCE = new VanillaMultiverseBiomes();
    private static final Set<ResourceKey<Biome>> OVERWORLD;
    private static final Set<ResourceKey<Biome>> NETHER;
    private static final Set<ResourceKey<Biome>> END;
    private static final Map<ResourceKey<Biome>, List<Climate.ParameterPoint>> PARAMETERS;
    private static final Climate.ParameterPoint ZERO;

    protected VanillaMultiverseBiomes() {
    }

    private static List<Climate.ParameterPoint> getEndParameters(float min, float max) {
        return List.of(Climate.parameters((Climate.Parameter)Climate.Parameter.point((float)0.0f), (Climate.Parameter)Climate.Parameter.point((float)0.0f), (Climate.Parameter)Climate.Parameter.point((float)0.0f), (Climate.Parameter)Climate.Parameter.span((float)min, (float)max), (Climate.Parameter)Climate.Parameter.point((float)0.0f), (Climate.Parameter)Climate.Parameter.point((float)0.0f), (float)0.0f));
    }

    public static Map<ResourceKey<Biome>, List<Climate.ParameterPoint>> getParameters() {
        return PARAMETERS;
    }

    @Override
    public Set<ResourceKey<Biome>> getOverworldBiomes() {
        return OVERWORLD;
    }

    @Override
    public Set<ResourceKey<Biome>> getNetherBiomes() {
        return NETHER;
    }

    @Override
    public Set<ResourceKey<Biome>> getEndBiomes() {
        return END;
    }

    @Override
    public List<Climate.ParameterPoint> getParameters(ResourceKey<Biome> biome, RandomSource random) {
        return PARAMETERS.getOrDefault(biome, List.of(ZERO));
    }

    @Override
    public SurfaceRules.RuleSource createSurface(boolean floor, boolean ceiling, MultiverseType type) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case MultiverseType.OVERWORLD -> MultiverseSurfaceRuleData.overworld(floor && !ceiling, ceiling, floor, Collections.emptySet());
            case MultiverseType.NETHER -> MultiverseSurfaceRuleData.nether(ceiling, floor, Collections.emptySet());
            case MultiverseType.END -> MultiverseSurfaceRuleData.end(ceiling, floor, Collections.emptySet());
        };
    }

    static {
        NETHER = Set.of(Biomes.NETHER_WASTES, Biomes.WARPED_FOREST, Biomes.CRIMSON_FOREST, Biomes.SOUL_SAND_VALLEY, Biomes.BASALT_DELTAS);
        END = Set.of(Biomes.END_HIGHLANDS, Biomes.END_MIDLANDS, Biomes.SMALL_END_ISLANDS, Biomes.END_BARRENS);
        PARAMETERS = new HashMap<ResourceKey<Biome>, List<Climate.ParameterPoint>>();
        ZERO = Climate.parameters((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        PARAMETERS.put((ResourceKey<Biome>)Biomes.NETHER_WASTES, List.of(Climate.parameters((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f)));
        PARAMETERS.put((ResourceKey<Biome>)Biomes.SOUL_SAND_VALLEY, List.of(Climate.parameters((float)0.0f, (float)-0.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f)));
        PARAMETERS.put((ResourceKey<Biome>)Biomes.CRIMSON_FOREST, List.of(Climate.parameters((float)0.4f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f)));
        PARAMETERS.put((ResourceKey<Biome>)Biomes.WARPED_FOREST, List.of(Climate.parameters((float)0.0f, (float)0.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.375f)));
        PARAMETERS.put((ResourceKey<Biome>)Biomes.BASALT_DELTAS, List.of(Climate.parameters((float)-0.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.175f)));
        PARAMETERS.put((ResourceKey<Biome>)Biomes.END_HIGHLANDS, VanillaMultiverseBiomes.getEndParameters(0.25f, 1.0f));
        PARAMETERS.put((ResourceKey<Biome>)Biomes.END_MIDLANDS, VanillaMultiverseBiomes.getEndParameters(-0.0625f, 0.25f));
        PARAMETERS.put((ResourceKey<Biome>)Biomes.SMALL_END_ISLANDS, VanillaMultiverseBiomes.getEndParameters(-1.0f, -0.21875f));
        PARAMETERS.put((ResourceKey<Biome>)Biomes.END_BARRENS, VanillaMultiverseBiomes.getEndParameters(-0.21875f, -0.0625f));
        ImmutableSet.Builder overworld = ImmutableSet.builder();
        new OverworldBiomeBuilder().addBiomes(pair -> {
            List<Object> add;
            ResourceKey key = (ResourceKey)pair.getSecond();
            overworld.add((Object)key);
            if (PARAMETERS.containsKey(key)) {
                add = PARAMETERS.get(key);
            } else {
                add = new ArrayList();
                PARAMETERS.put((ResourceKey<Biome>)key, add);
            }
            add.add((Climate.ParameterPoint)pair.getFirst());
        });
        OVERWORLD = overworld.build();
    }
}

