/*
 * Decompiled with CFR 0.152.
 */
package io.github.davidqf555.minecraft.multiverse.common.world.worldgen.features.placement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.davidqf555.minecraft.multiverse.registration.worldgen.PlacementRegistry;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;

public class SolidPlacement
extends PlacementModifier {
    public static final MapCodec<SolidPlacement> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Direction.CODEC.fieldOf("direction").forGetter(placement -> placement.dir), (App)ExtraCodecs.POSITIVE_INT.fieldOf("steps").forGetter(placement -> placement.steps)).apply((Applicative)inst, SolidPlacement::of));
    private final Direction dir;
    private final int steps;
    private final BlockPredicate solid;

    protected SolidPlacement(Direction dir, int steps) {
        this.dir = dir;
        this.steps = steps;
        this.solid = BlockPredicate.solid((Vec3i)dir.getUnitVec3i());
    }

    public static SolidPlacement of(Direction dir, int steps) {
        return new SolidPlacement(dir, steps);
    }

    public Stream<BlockPos> getPositions(PlacementContext context, RandomSource random, BlockPos pos) {
        WorldGenLevel level = context.getLevel();
        BlockPos.MutableBlockPos mutable = pos.mutable();
        for (int step = 0; step < this.steps && !level.isOutsideBuildHeight((BlockPos)mutable) && BlockPredicate.ONLY_IN_AIR_OR_WATER_PREDICATE.test((Object)level, (Object)mutable); ++step) {
            if (this.solid.test((Object)level, (Object)mutable)) {
                return Stream.of(mutable);
            }
            mutable.move(this.dir);
        }
        return Stream.empty();
    }

    public PlacementModifierType<?> type() {
        return (PlacementModifierType)PlacementRegistry.SOLID.get();
    }
}

