/*
 * Decompiled with CFR 0.152.
 */
package io.github.davidqf555.minecraft.multiverse.common.world.worldgen.providers;

import io.github.davidqf555.minecraft.multiverse.common.world.DimensionHelper;
import io.github.davidqf555.minecraft.multiverse.common.world.worldgen.MultiverseShape;
import io.github.davidqf555.minecraft.multiverse.common.world.worldgen.ShapesManager;
import java.util.List;
import net.minecraft.core.RegistryAccess;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;

public class ShapeDimensionProvider {
    public static final ShapeDimensionProvider INSTANCE = new ShapeDimensionProvider();

    protected ShapeDimensionProvider() {
    }

    public LevelStem createDimension(RegistryAccess access, long seed, RandomSource random) {
        List<ShapesManager.Entry> all = ShapesManager.INSTANCE.getShapes();
        int total = all.stream().mapToInt(ShapesManager.Entry::weight).sum();
        int rand = random.nextInt(total);
        for (ShapesManager.Entry entry : all) {
            if ((total -= entry.weight()) > rand) continue;
            return ((MultiverseShape)entry.shape().value()).getDimensionProvider().createDimension(access, seed, random);
        }
        throw new RuntimeException("Should never get here");
    }

    public LevelStem createDimension(RegistryAccess access, long base, int index) {
        long seed = DimensionHelper.getSeed(base, index);
        WorldgenRandom random = new WorldgenRandom((RandomSource)new XoroshiroRandomSource(seed));
        return this.createDimension(access, seed, (RandomSource)random);
    }
}

