/*
 * Decompiled with CFR 0.152.
 */
package io.github.davidqf555.minecraft.multiverse.common.world.worldgen.providers.biomes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.davidqf555.minecraft.multiverse.common.world.worldgen.MultiverseType;
import io.github.davidqf555.minecraft.multiverse.common.world.worldgen.biomes.BiomeConfig;
import io.github.davidqf555.minecraft.multiverse.common.world.worldgen.providers.DimensionProvider;
import io.github.davidqf555.minecraft.multiverse.common.world.worldgen.providers.biomes.BiomeDimensionProvider;
import io.github.davidqf555.minecraft.multiverse.registration.custom.DimensionProviderTypeRegistry;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.dimension.LevelStem;

public class BiomeConfigDimensionProvider
implements DimensionProvider {
    public static final MapCodec<BiomeConfigDimensionProvider> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)BiomeConfig.CODEC.fieldOf("biomes").forGetter(val -> val.config), (App)BiomeDimensionProvider.CODEC.fieldOf("dimension").forGetter(val -> val.provider)).apply((Applicative)inst, BiomeConfigDimensionProvider::new));
    private final Holder<BiomeConfig> config;
    private final BiomeDimensionProvider provider;

    public BiomeConfigDimensionProvider(Holder<BiomeConfig> config, BiomeDimensionProvider provider) {
        this.config = config;
        this.provider = provider;
    }

    @Override
    public LevelStem createDimension(RegistryAccess access, long seed, RandomSource random) {
        BiomeConfig config = (BiomeConfig)this.config.value();
        Pair<MultiverseType, Set<HolderSet<Biome>>> biomes = config.selectRandom((Registry<Biome>)access.lookupOrThrow(Registries.BIOME), random);
        return (LevelStem)this.provider.provide(access, seed, random, (MultiverseType)((Object)biomes.getFirst()), (Set)biomes.getSecond());
    }

    public MapCodec<? extends BiomeConfigDimensionProvider> getCodec() {
        return (MapCodec)DimensionProviderTypeRegistry.BIOME_CONFIG.get();
    }
}

