/*
 * Decompiled with CFR 0.152.
 */
package io.github.davidqf555.minecraft.multiverse.common.world.worldgen.providers.biomes.chunk_gen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.davidqf555.minecraft.multiverse.common.world.worldgen.MultiverseNoiseChunkGenerator;
import io.github.davidqf555.minecraft.multiverse.common.world.worldgen.MultiverseType;
import io.github.davidqf555.minecraft.multiverse.common.world.worldgen.providers.biomes.chunk_gen.BiomeChunkGeneratorProvider;
import io.github.davidqf555.minecraft.multiverse.common.world.worldgen.providers.biomes.chunk_gen.biome_source.BiomeSourceProvider;
import io.github.davidqf555.minecraft.multiverse.common.world.worldgen.providers.biomes.chunk_gen.noise_settings.BiomeNoiseGeneratorSettingsProvider;
import io.github.davidqf555.minecraft.multiverse.common.world.worldgen.providers.biomes.chunk_gen.sea_level.SeaLevelProvider;
import io.github.davidqf555.minecraft.multiverse.common.world.worldgen.providers.biomes.chunk_gen.sea_level.fluid_pickers.SerializableFluidPicker;
import io.github.davidqf555.minecraft.multiverse.registration.custom.biomes.BiomeChunkGeneratorProviderTypeRegistry;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryAccess;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;

public class NoiseChunkGeneratorProvider
implements BiomeChunkGeneratorProvider<MultiverseNoiseChunkGenerator> {
    public static final MapCodec<NoiseChunkGeneratorProvider> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)SeaLevelProvider.CODEC.fieldOf("sea_level").forGetter(val -> val.sea), (App)BiomeNoiseGeneratorSettingsProvider.CODEC.fieldOf("noise_settings").forGetter(val -> val.noise), (App)BiomeSourceProvider.CODEC.fieldOf("biomes").forGetter(val -> val.biomes)).apply((Applicative)inst, NoiseChunkGeneratorProvider::new));
    private final Holder<BiomeNoiseGeneratorSettingsProvider> noise;
    private final Holder<SeaLevelProvider> sea;
    private final BiomeSourceProvider<?> biomes;

    public NoiseChunkGeneratorProvider(Holder<SeaLevelProvider> sea, Holder<BiomeNoiseGeneratorSettingsProvider> noise, BiomeSourceProvider<?> biomes) {
        this.noise = noise;
        this.sea = sea;
        this.biomes = biomes;
    }

    @Override
    public MultiverseNoiseChunkGenerator provide(RegistryAccess access, long seed, RandomSource random, MultiverseType type, Set<HolderSet<Biome>> biomes) {
        BiomeSource source = (BiomeSource)this.biomes.provide(access, seed, random, type, biomes);
        Holder noise = (Holder)((BiomeNoiseGeneratorSettingsProvider)this.noise.value()).provide(access, seed, random, type, biomes);
        SerializableFluidPicker fluid = ((SeaLevelProvider)this.sea.value()).getSeaLevel(((NoiseGeneratorSettings)noise.value()).defaultFluid(), random);
        return new MultiverseNoiseChunkGenerator(source, (Holder<NoiseGeneratorSettings>)noise, fluid);
    }

    @Override
    public MapCodec<? extends NoiseChunkGeneratorProvider> getCodec() {
        return (MapCodec)BiomeChunkGeneratorProviderTypeRegistry.NOISE.get();
    }
}

