/*
 * Decompiled with CFR 0.152.
 */
package io.github.davidqf555.minecraft.multiverse.common.world.worldgen.providers.biomes.chunk_gen.biome_source;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.davidqf555.minecraft.multiverse.common.world.worldgen.MultiverseType;
import io.github.davidqf555.minecraft.multiverse.common.world.worldgen.biomes.LazyMultiverseBiomeSource;
import io.github.davidqf555.minecraft.multiverse.common.world.worldgen.providers.biomes.chunk_gen.biome_source.BiomeSourceProvider;
import java.util.Set;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.dimension.DimensionType;

public class NoiseBiomeSourceProvider
implements BiomeSourceProvider<LazyMultiverseBiomeSource> {
    public static final MapCodec<NoiseBiomeSourceProvider> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Codec.INT.fieldOf("min_y").forGetter(val -> val.minY), (App)Codec.INT.fieldOf("max_y").forGetter(val -> val.maxY)).apply((Applicative)inst, NoiseBiomeSourceProvider::new));
    private static final long OFFSET = 55555L;
    private final int minY;
    private final int maxY;

    public NoiseBiomeSourceProvider(int minY, int maxY) {
        this.minY = minY;
        this.maxY = maxY;
    }

    @Override
    public LazyMultiverseBiomeSource provide(RegistryAccess access, long seed, RandomSource random, MultiverseType type, Set<HolderSet<Biome>> biomes) {
        return new LazyMultiverseBiomeSource((HolderLookup.RegistryLookup<Biome>)access.lookupOrThrow(Registries.BIOME), (HolderLookup.RegistryLookup<DimensionType>)access.lookupOrThrow(Registries.DIMENSION_TYPE), this.minY, this.maxY, type, biomes, seed + 55555L);
    }

    @Override
    public MapCodec<? extends NoiseBiomeSourceProvider> getCodec() {
        return CODEC;
    }
}

