/*
 * Decompiled with CFR 0.152.
 */
package io.github.davidqf555.minecraft.multiverse.common.world.worldgen.providers.biomes.dim_type;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.davidqf555.minecraft.multiverse.common.world.worldgen.MultiverseType;
import io.github.davidqf555.minecraft.multiverse.common.world.worldgen.providers.biomes.dim_type.BiomeDimensionTypeProvider;
import io.github.davidqf555.minecraft.multiverse.registration.custom.biomes.BiomeDimensionTypeProviderTypeRegistry;
import java.util.List;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryAccess;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.dimension.DimensionType;

public class WeightedDimensionTypeProvider
implements BiomeDimensionTypeProvider {
    public static final MapCodec<WeightedDimensionTypeProvider> CODEC = Entry.CODEC.listOf().xmap(WeightedDimensionTypeProvider::new, val -> val.entries).fieldOf("entries");
    private final List<Entry> entries;

    public WeightedDimensionTypeProvider(List<Entry> entries) {
        if (entries.stream().mapToInt(Entry::weight).sum() <= 0 || entries.stream().mapToInt(Entry::weight).anyMatch(weight -> weight < 0)) {
            throw new IllegalArgumentException("Invalid weights");
        }
        this.entries = entries;
    }

    @Override
    public Holder<DimensionType> provide(RegistryAccess access, long seed, RandomSource random, MultiverseType type, Set<HolderSet<Biome>> biomes) {
        int total = this.entries.stream().mapToInt(Entry::weight).sum();
        int rand = random.nextInt(total);
        for (Entry entry : this.entries) {
            if (rand < (total -= entry.weight())) continue;
            return entry.value();
        }
        throw new RuntimeException("Should never get here");
    }

    public MapCodec<? extends WeightedDimensionTypeProvider> getCodec() {
        return (MapCodec)BiomeDimensionTypeProviderTypeRegistry.WEIGHTED.get();
    }

    public record Entry(Holder<DimensionType> value, int weight) {
        public static final Codec<Entry> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)DimensionType.CODEC.fieldOf("value").forGetter(Entry::value), (App)ExtraCodecs.NON_NEGATIVE_INT.optionalFieldOf("weight", (Object)1).forGetter(Entry::weight)).apply((Applicative)inst, Entry::new));
    }
}

