/*
 * Decompiled with CFR 0.152.
 */
package io.github.davidqf555.minecraft.multiverse.datagen;

import io.github.davidqf555.minecraft.multiverse.datagen.DimensionTypeRegistry;
import io.github.davidqf555.minecraft.multiverse.datagen.NoiseSettingsRegistry;
import java.util.Set;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.DatapackBuiltinEntriesProvider;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="multiverse", bus=EventBusSubscriber.Bus.MOD)
public final class DataGenRegistry {
    private DataGenRegistry() {
    }

    @SubscribeEvent
    public static void onGatherServerData(GatherDataEvent.Server event) {
        DataGenerator gen = event.getGenerator();
        gen.addProvider(true, (DataProvider)new DatapackBuiltinEntriesProvider(gen.getPackOutput(), event.getLookupProvider(), new RegistrySetBuilder().add(Registries.NOISE_SETTINGS, context -> {
            HolderGetter density = context.lookup(Registries.DENSITY_FUNCTION);
            HolderGetter parameters = context.lookup(Registries.NOISE);
            NoiseSettingsRegistry.SETTINGS.forEach((loc, val) -> context.register(ResourceKey.create((ResourceKey)Registries.NOISE_SETTINGS, (ResourceLocation)loc), (Object)val.settings().apply((HolderGetter<DensityFunction>)density, (HolderGetter<NormalNoise.NoiseParameters>)parameters)));
        }).add(Registries.DIMENSION_TYPE, context -> DimensionTypeRegistry.TYPES.forEach((loc, type) -> context.register(ResourceKey.create((ResourceKey)Registries.DIMENSION_TYPE, (ResourceLocation)loc), type))), Set.of("multiverse")));
    }
}

