/*
 * Decompiled with CFR 0.152.
 */
package io.github.davidqf555.minecraft.multiverse.datagen;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import io.github.davidqf555.minecraft.multiverse.common.world.worldgen.LazyMultiverseSurfaceRuleSource;
import io.github.davidqf555.minecraft.multiverse.common.world.worldgen.MultiverseType;
import io.github.davidqf555.minecraft.multiverse.datagen.MultiverseNoiseRouters;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import net.minecraft.core.HolderGetter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.NoiseRouter;
import net.minecraft.world.level.levelgen.NoiseRouterData;
import net.minecraft.world.level.levelgen.NoiseSettings;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.synth.NormalNoise;

public final class NoiseSettingsRegistry {
    public static final Map<ResourceLocation, NoiseSettingsEntry> SETTINGS;

    private NoiseSettingsRegistry() {
    }

    static {
        List<Pair> shapes = List.of(Pair.of((Object)"normal", (Object)new SettingsValue(true, false, true, NoiseSettings.create((int)-64, (int)384, (int)1, (int)2), (density, noise) -> NoiseRouterData.overworld((HolderGetter)density, (HolderGetter)noise, (boolean)false, (boolean)false))), Pair.of((Object)"amplified", (Object)new SettingsValue(true, false, true, NoiseSettings.create((int)-64, (int)384, (int)1, (int)2), (density, noise) -> NoiseRouterData.overworld((HolderGetter)density, (HolderGetter)noise, (boolean)false, (boolean)true))), Pair.of((Object)"flooded/normal", (Object)new SettingsValue(true, false, false, NoiseSettings.create((int)-64, (int)384, (int)1, (int)2), (density, noise) -> NoiseRouterData.overworld((HolderGetter)density, (HolderGetter)noise, (boolean)false, (boolean)false))), Pair.of((Object)"flooded/amplified", (Object)new SettingsValue(true, false, false, NoiseSettings.create((int)-64, (int)384, (int)1, (int)2), (density, noise) -> NoiseRouterData.overworld((HolderGetter)density, (HolderGetter)noise, (boolean)false, (boolean)true))), Pair.of((Object)"roofed", (Object)new SettingsValue(true, true, false, NoiseSettings.create((int)0, (int)128, (int)1, (int)2), NoiseRouterData::nether)), Pair.of((Object)"islands", (Object)new SettingsValue(false, false, false, NoiseSettings.create((int)0, (int)256, (int)2, (int)1), NoiseRouterData::floatingIslands)), Pair.of((Object)"noodles", (Object)new SettingsValue(false, false, false, NoiseSettings.create((int)0, (int)256, (int)2, (int)1), (density, noise) -> MultiverseNoiseRouters.noodles((HolderGetter<DensityFunction>)density, (HolderGetter<NormalNoise.NoiseParameters>)noise, 0, 256))), Pair.of((Object)"blobs", (Object)new SettingsValue(false, false, false, NoiseSettings.create((int)0, (int)256, (int)2, (int)1), (density, noise) -> MultiverseNoiseRouters.blobs((HolderGetter<DensityFunction>)density, (HolderGetter<NormalNoise.NoiseParameters>)noise, 0, 256))));
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Pair pair : shapes) {
            SettingsValue val = (SettingsValue)pair.getSecond();
            boolean floor = val.floor();
            boolean ceiling = val.ceiling();
            NoiseSettings noise2 = val.noise();
            for (MultiverseType type : MultiverseType.values()) {
                ResourceLocation loc = ResourceLocation.fromNamespaceAndPath((String)"multiverse", (String)((String)pair.getFirst() + "/" + type.getName()));
                builder.put((Object)loc, (Object)new NoiseSettingsEntry((density, hol) -> new NoiseGeneratorSettings(noise2, type.getDefaultBlock(), type.getDefaultFluid(), val.router().apply((HolderGetter<DensityFunction>)density, (HolderGetter<NormalNoise.NoiseParameters>)hol), (SurfaceRules.RuleSource)new LazyMultiverseSurfaceRuleSource(floor, ceiling, type), List.of(), 0, false, val.aquifers(), true, false), type, floor, ceiling));
            }
        }
        SETTINGS = builder.build();
    }

    private record SettingsValue(boolean floor, boolean ceiling, boolean aquifers, NoiseSettings noise, BiFunction<HolderGetter<DensityFunction>, HolderGetter<NormalNoise.NoiseParameters>, NoiseRouter> router) {
    }

    public record NoiseSettingsEntry(BiFunction<HolderGetter<DensityFunction>, HolderGetter<NormalNoise.NoiseParameters>, NoiseGeneratorSettings> settings, MultiverseType type, boolean floor, boolean ceiling) {
    }
}

