/*
 * Decompiled with CFR 0.152.
 */
package io.github.davidqf555.minecraft.multiverse.registration.custom;

import com.mojang.serialization.MapCodec;
import io.github.davidqf555.minecraft.multiverse.common.world.worldgen.providers.biomes.chunk_gen.sea_level.fluid_pickers.FlatFluidPicker;
import io.github.davidqf555.minecraft.multiverse.common.world.worldgen.providers.biomes.chunk_gen.sea_level.fluid_pickers.SerializableFluidPicker;
import io.github.davidqf555.minecraft.multiverse.common.world.worldgen.providers.biomes.chunk_gen.sea_level.fluid_pickers.WaveFluidPicker;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NewRegistryEvent;
import net.neoforged.neoforge.registries.RegistryBuilder;

@EventBusSubscriber(modid="multiverse", bus=EventBusSubscriber.Bus.MOD)
public final class FluidPickerTypeRegistry {
    public static final ResourceKey<Registry<MapCodec<? extends SerializableFluidPicker>>> LOCATION = ResourceKey.createRegistryKey((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"multiverse", (String)"fluid_picker"));
    public static final DeferredRegister<MapCodec<? extends SerializableFluidPicker>> TYPES = DeferredRegister.create(LOCATION, (String)"multiverse");
    public static final DeferredHolder<MapCodec<? extends SerializableFluidPicker>, MapCodec<FlatFluidPicker>> FLAT = FluidPickerTypeRegistry.register("flat", () -> FlatFluidPicker.CODEC);
    public static final DeferredHolder<MapCodec<? extends SerializableFluidPicker>, MapCodec<WaveFluidPicker>> WAVE = FluidPickerTypeRegistry.register("wave", () -> WaveFluidPicker.CODEC);
    private static Registry<MapCodec<? extends SerializableFluidPicker>> registry = null;

    private FluidPickerTypeRegistry() {
    }

    private static <T extends SerializableFluidPicker> DeferredHolder<MapCodec<? extends SerializableFluidPicker>, MapCodec<T>> register(String name, Supplier<MapCodec<T>> codec) {
        return TYPES.register(name, codec);
    }

    public static Registry<MapCodec<? extends SerializableFluidPicker>> getRegistry() {
        return registry;
    }

    @SubscribeEvent
    public static void onNewRegistry(NewRegistryEvent event) {
        registry = event.create(new RegistryBuilder(LOCATION));
    }
}

