/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.netherportalspread.neoforge.events;

import com.natamus.collective_common_neoforge.functions.WorldFunctions;
import com.natamus.netherportalspread_common_neoforge.events.SpreadEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;

@EventBusSubscriber
public class NeoForgeSpreadEvent {
    @SubscribeEvent
    public static void onWorldTick(LevelTickEvent.Post e) {
        Level level = e.getLevel();
        if (level.isClientSide) {
            return;
        }
        SpreadEvent.onWorldTick((ServerLevel)level);
    }

    @SubscribeEvent
    public static void onWorldLoad(LevelEvent.Load e) {
        Level level = WorldFunctions.getWorldIfInstanceOfAndNotRemote((LevelAccessor)e.getLevel());
        if (level == null) {
            return;
        }
        SpreadEvent.onWorldLoad((ServerLevel)level);
    }

    @SubscribeEvent
    public static void onPortalSpawn(BlockEvent.PortalSpawnEvent e) {
        Level level = WorldFunctions.getWorldIfInstanceOfAndNotRemote((LevelAccessor)e.getLevel());
        if (level == null) {
            return;
        }
        SpreadEvent.onPortalSpawn(level, e.getPos(), e.getPortalSize());
    }

    @SubscribeEvent
    public static void onDimensionChange(PlayerEvent.PlayerChangedDimensionEvent e) {
        Player player = e.getEntity();
        Level level = player.level();
        if (level.isClientSide) {
            return;
        }
        SpreadEvent.onDimensionChange((ServerLevel)level, (ServerPlayer)player);
    }
}

