/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.ore_creeper.block;

import com.cozary.ore_creeper.entities.OrePrimedTnt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OreTnt
extends Block {
    public static final BooleanProperty UNSTABLE = BlockStateProperties.UNSTABLE;

    public OreTnt() {
        super(BlockBehaviour.Properties.of().setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"ore_creeper", (String)"ore_tnt"))).mapColor(MapColor.FIRE).ignitedByLava().instabreak().sound(SoundType.GRASS));
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)UNSTABLE, (Comparable)Boolean.valueOf(false)));
    }

    public static void explode(Level $$0, BlockPos $$1) {
        OreTnt.explode($$0, $$1, null);
    }

    private static void explode(Level level, BlockPos pos, @Nullable LivingEntity entity) {
        if (!level.isClientSide) {
            OrePrimedTnt primedtnt = new OrePrimedTnt(level, (double)pos.getX() + 0.5, pos.getY(), (double)pos.getZ() + 0.5, entity);
            level.addFreshEntity((Entity)primedtnt);
            level.playSound(null, primedtnt.getX(), primedtnt.getY(), primedtnt.getZ(), SoundEvents.TNT_PRIMED, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.gameEvent((Entity)entity, (Holder)GameEvent.PRIME_FUSE, pos);
        }
    }

    public void onPlace(BlockState $$0, Level $$1, BlockPos $$2, BlockState $$3, boolean $$4) {
        if (!$$3.is($$0.getBlock()) && $$1.hasNeighborSignal($$2)) {
            OreTnt.explode($$1, $$2);
            $$1.removeBlock($$2, false);
        }
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighborBlock, @Nullable Orientation orientation, boolean movedByPiston) {
        if (level.hasNeighborSignal(pos)) {
            OreTnt.explode(level, pos);
            level.removeBlock(pos, false);
        }
    }

    @NotNull
    public BlockState playerWillDestroy(Level $$0, BlockPos $$1, BlockState $$2, Player $$3) {
        if (!$$0.isClientSide() && !$$3.isCreative() && ((Boolean)$$2.getValue((Property)UNSTABLE)).booleanValue()) {
            OreTnt.explode($$0, $$1);
        }
        return super.playerWillDestroy($$0, $$1, $$2, $$3);
    }

    public void wasExploded(ServerLevel level, BlockPos pos, Explosion explosion) {
        OrePrimedTnt primedtnt = new OrePrimedTnt((Level)level, (double)pos.getX() + 0.5, pos.getY(), (double)pos.getZ() + 0.5, explosion.getIndirectSourceEntity());
        int i = primedtnt.getFuse();
        primedtnt.setFuse((short)(level.random.nextInt(i / 4) + i / 8));
        level.addFreshEntity((Entity)primedtnt);
    }

    protected InteractionResult useItemOn(ItemStack itemStack, BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        if (!itemStack.is(Items.FLINT_AND_STEEL) && !itemStack.is(Items.FIRE_CHARGE)) {
            return super.useItemOn(itemStack, blockState, level, blockPos, player, interactionHand, blockHitResult);
        }
        OreTnt.explode(level, blockPos, (LivingEntity)player);
        level.setBlock(blockPos, Blocks.AIR.defaultBlockState(), 11);
        Item $$7 = itemStack.getItem();
        if (!player.isCreative()) {
            if (itemStack.is(Items.FLINT_AND_STEEL)) {
                itemStack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)interactionHand));
            } else {
                itemStack.shrink(1);
            }
        }
        player.awardStat(Stats.ITEM_USED.get((Object)$$7));
        return InteractionResult.SUCCESS;
    }

    protected void onProjectileHit(Level level, BlockState state, BlockHitResult hit, Projectile projectile) {
        if (level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            BlockPos blockpos = hit.getBlockPos();
            Entity entity = projectile.getOwner();
            if (projectile.isOnFire() && projectile.mayInteract(serverlevel, blockpos)) {
                OreTnt.explode(level, blockpos, entity instanceof LivingEntity ? (LivingEntity)entity : null);
                level.removeBlock(blockpos, false);
            }
        }
    }

    public boolean dropFromExplosion(Explosion $$0) {
        return false;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> $$0) {
        $$0.add(new Property[]{UNSTABLE});
    }
}

