/*
 * Decompiled with CFR 0.152.
 */
package io.github.thepoultryman.particlemoths;

import io.github.thepoultryman.particlemoths.MothHelper;
import io.github.thepoultryman.particlemoths.config.ParticleMothsConfig;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.RisingParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.SimpleParticleType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class MothParticle
extends RisingParticle {
    SpriteSet sprites;

    protected MothParticle(ClientLevel clientLevel, double d, double e, double f, double g, double h, double i, SpriteSet sprites) {
        super(clientLevel, d, e, f, g, h, i);
        this.sprites = sprites;
        this.setSpriteFromAge(this.sprites);
        this.setAlpha(0.0f);
    }

    protected int getLightColor(float tint) {
        if (!ParticleMothsConfig.glowingMoths) {
            return super.getLightColor(tint);
        }
        return 240;
    }

    public void tick() {
        if (this.age == this.getLifetime() / 2) {
            this.setParticleSpeed(this.getVelocityForAge(this.xd), this.getVelocityForAge(this.yd), this.getVelocityForAge(this.zd));
        }
        super.tick();
        this.setSpriteFromAge(this.sprites);
        float maxAgeFraction = (float)this.lifetime / 5.0f;
        if ((float)this.age < maxAgeFraction) {
            this.setAlpha(this.alpha + 1.0f / maxAgeFraction);
        } else if ((float)this.age > maxAgeFraction * 4.0f) {
            float calculatedAlpha = this.alpha - 1.0f / maxAgeFraction;
            if (calculatedAlpha < 0.0f || calculatedAlpha > 1.0f) {
                this.setAlpha(0.0f);
            } else {
                this.setAlpha(calculatedAlpha);
            }
        }
    }

    @NotNull
    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    private double getVelocityForAge(double velocity) {
        return velocity + (double)(MothHelper.floatRange(-0.15f, 0.15f) / 100.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public record Factory(SpriteSet sprites) implements ParticleProvider<SimpleParticleType>
    {
        @NotNull
        public Particle createParticle(SimpleParticleType particleOptions, ClientLevel clientLevel, double d, double e, double f, double g, double h, double i) {
            return new MothParticle(clientLevel, d, e, f, g, h, i, this.sprites);
        }
    }
}

