/*
 * Decompiled with CFR 0.152.
 */
package io.github.thepoultryman.particlemoths.config;

import eu.midnightdust.lib.config.MidnightConfig;

public class ParticleMothsConfig
extends MidnightConfig {
    @MidnightConfig.Entry(category="general")
    public static MothSpawnMode spawnMoths = MothSpawnMode.ALL;
    @MidnightConfig.Entry(category="general")
    public static boolean glowingMoths = false;
    @MidnightConfig.Comment(category="general", centered=true)
    public static MidnightConfig.Comment movementConfig;
    @MidnightConfig.Entry(category="general")
    public static boolean specificVelocities;
    @MidnightConfig.Entry(category="general", isSlider=true, min=-500.0, max=500.0, precision=1)
    public static double xVelocity;
    @MidnightConfig.Entry(category="general", isSlider=true, min=-500.0, max=500.0, precision=1)
    public static double yVelocity;
    @MidnightConfig.Entry(category="general", isSlider=true, min=-500.0, max=500.0, precision=1)
    public static double zVelocity;
    @MidnightConfig.Entry(category="spawning", isSlider=true, min=0.0, max=99.0, precision=1)
    public static double mothCount;
    @MidnightConfig.Entry(category="spawning", isSlider=true, min=1.0, max=100.0, precision=1)
    public static double spawnProbability;
    @MidnightConfig.Comment(category="spawning", centered=true)
    public static MidnightConfig.Comment spawnDistances;
    @MidnightConfig.Entry(category="spawning")
    public static int xSpawnDistance;
    @MidnightConfig.Entry(category="spawning")
    public static int ySpawnDistance;
    @MidnightConfig.Entry(category="spawning")
    public static int zSpawnDistance;
    @MidnightConfig.Comment(category="spawning", centered=true)
    public static MidnightConfig.Comment heightLimits;
    @MidnightConfig.Entry(category="spawning")
    public static int negHeightLimit;
    @MidnightConfig.Entry(category="spawning")
    public static int posHeightLimit;
    @MidnightConfig.Entry(category="blockSpawning", isSlider=true, min=2.0, max=100.0, precision=1)
    public static double blockSpawnProbability;
    @MidnightConfig.Entry(category="blockSpawning")
    public static int xBlockSpawnDistance;
    @MidnightConfig.Entry(category="blockSpawning")
    public static int yBlockSpawnDistance;
    @MidnightConfig.Entry(category="blockSpawning")
    public static int zBlockSpawnDistance;
    @MidnightConfig.Comment(category="blockSpawning", centered=true)
    public static MidnightConfig.Comment allowedBlocks;
    @MidnightConfig.Entry(category="blockSpawning")
    public static boolean torches;
    @MidnightConfig.Entry(category="blockSpawning")
    public static boolean redstoneTorches;
    @MidnightConfig.Entry(category="blockSpawning")
    public static boolean redstoneLamps;
    @MidnightConfig.Entry(category="blockSpawning")
    public static boolean lanterns;
    @MidnightConfig.Entry(category="blockSpawning")
    public static boolean candles;

    public static boolean spawnMoths(MothSpawnMode type) {
        if (spawnMoths == MothSpawnMode.ALL) {
            return true;
        }
        switch (type.ordinal()) {
            case 1: {
                return spawnMoths == MothSpawnMode.WORLD;
            }
            case 2: {
                return spawnMoths == MothSpawnMode.BLOCKS;
            }
        }
        return false;
    }

    static {
        specificVelocities = false;
        xVelocity = 100.0;
        yVelocity = 100.0;
        zVelocity = 100.0;
        mothCount = 15.0;
        spawnProbability = 13.0;
        xSpawnDistance = 30;
        ySpawnDistance = 30;
        zSpawnDistance = 30;
        negHeightLimit = -10;
        posHeightLimit = 192;
        blockSpawnProbability = 15.0;
        xBlockSpawnDistance = 3;
        yBlockSpawnDistance = 3;
        zBlockSpawnDistance = 3;
        torches = true;
        redstoneTorches = true;
        redstoneLamps = true;
        lanterns = true;
        candles = true;
    }

    public static enum MothSpawnMode {
        ALL,
        WORLD,
        BLOCKS,
        NEVER;

    }
}

