/*
 * Decompiled with CFR 0.152.
 */
package io.github.thepoultryman.particlemoths.neoforge;

import io.github.thepoultryman.particlemoths.MothParticle;
import io.github.thepoultryman.particlemoths.MothSpawnHelper;
import io.github.thepoultryman.particlemoths.ParticleMoths;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@Mod(value="particlemoths", dist={Dist.CLIENT})
public class ParticleMothsNeoForge {
    public static final DeferredRegister<ParticleType<?>> PARTICLE_REGISTER = DeferredRegister.create((Registry)BuiltInRegistries.PARTICLE_TYPE, (String)"particlemoths");
    public static final DeferredHolder<ParticleType<?>, SimpleParticleType> MOTH = PARTICLE_REGISTER.register("moth", () -> new SimpleParticleType(false));

    public ParticleMothsNeoForge(IEventBus eventBus) {
        ParticleMoths.init();
        PARTICLE_REGISTER.register(eventBus);
        eventBus.addListener(ParticleMothsNeoForge::registerParticleProviders);
        NeoForge.EVENT_BUS.addListener(ParticleMothsNeoForge::clientPostTick);
    }

    @SubscribeEvent
    public static void registerParticleProviders(RegisterParticleProvidersEvent event) {
        event.registerSpriteSet((ParticleType)ParticleMoths.getOptions(), MothParticle.Factory::new);
    }

    @SubscribeEvent
    public static void clientPostTick(ClientTickEvent.Post event) {
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft.level == null || !MothSpawnHelper.shouldSpawnMoth(minecraft)) {
            return;
        }
        ClientLevel level = minecraft.level;
        LocalPlayer player = minecraft.player;
        if (player == null) {
            return;
        }
        BlockPos spawnPos = MothSpawnHelper.getSpawnCoordinates(player.getOnPos());
        if (!MothSpawnHelper.isValidMothSpawn((Level)level, spawnPos, minecraft)) {
            return;
        }
        double[] velocities = MothSpawnHelper.getVelocity();
        level.addParticle((ParticleOptions)ParticleMoths.getOptions(), (double)spawnPos.getX(), (double)spawnPos.getY(), (double)spawnPos.getZ(), velocities[0], velocities[1], velocities[2]);
    }
}

