/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.pottery;

import com.supermartijn642.core.registry.ClientRegistrationHandler;
import com.supermartijn642.core.render.TextureAtlases;
import com.supermartijn642.pottery.content.PotBakedModel;
import com.supermartijn642.pottery.content.PotBlockRenderer;
import com.supermartijn642.pottery.content.PotColor;
import com.supermartijn642.pottery.content.PotItemModel;
import com.supermartijn642.pottery.content.PotType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.block.entity.DecoratedPotPattern;

public class PotteryClient {
    public static void register() {
        ClientRegistrationHandler handler = ClientRegistrationHandler.get((String)"pottery");
        for (PotType type : PotType.values()) {
            handler.registerCustomBlockEntityRenderer(type::getBlockEntityType, PotBlockRenderer::new);
        }
        for (PotType type : PotType.values()) {
            for (PotColor color : PotColor.values()) {
                if (type == PotType.DEFAULT && color == PotColor.BLANK) continue;
                handler.registerBlockModelOverwrite(() -> type.getBlock(color), PotBakedModel::new);
            }
        }
        handler.registerItemModelType("decorated_pot", PotItemModel.CODEC);
        BuiltInRegistries.DECORATED_POT_PATTERN.listElements().filter(holder -> holder.key().location().getNamespace().equals("minecraft")).map(holder -> ((DecoratedPotPattern)holder.value()).assetId().withPrefix("entity/decorated_pot/")).forEach(texture -> handler.registerAtlasSprite(TextureAtlases.getBlocks(), texture));
    }
}

