/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.pottery.content;

import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.block.BaseBlock;
import com.supermartijn642.core.block.BlockProperties;
import com.supermartijn642.core.block.EntityHoldingBlock;
import com.supermartijn642.pottery.content.DecorationUtils;
import com.supermartijn642.pottery.content.PotBlockEntity;
import com.supermartijn642.pottery.content.PotColor;
import com.supermartijn642.pottery.content.PotType;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DecoratedPotBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.DecoratedPotBlockEntity;
import net.minecraft.world.level.block.entity.PotDecorations;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class PotBlock
extends BaseBlock
implements EntityHoldingBlock,
SimpleWaterloggedBlock {
    public static final EnumProperty<Direction> HORIZONTAL_FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty CRACKED = BlockStateProperties.CRACKED;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private final PotType type;
    private final PotColor color;

    public PotBlock(PotType type, PotColor color) {
        super(false, BlockProperties.create().mapColor(MapColor.NONE).destroyTime(0.0f).explosionResistance(0.0f).noOcclusion().toUnderlying().pushReaction(PushReaction.DESTROY));
        this.type = type;
        this.color = color;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)CRACKED, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public PotType getType() {
        return this.type;
    }

    public PotColor getColor() {
        return this.color;
    }

    protected BaseBlock.InteractionFeedback interact(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, Direction hitSide, Vec3 hitLocation) {
        BlockEntity decorations;
        BlockEntity entity2;
        ItemStack stack = player.getItemInHand(hand);
        if (stack.getItem() instanceof DyeItem) {
            PotColor color = PotColor.colorForDye(((DyeItem)stack.getItem()).getDyeColor());
            if (color == null || color == this.color) {
                return BaseBlock.InteractionFeedback.CONSUME;
            }
            if (!level.isClientSide) {
                BlockEntity entity2 = level.getBlockEntity(pos);
                if (!(entity2 instanceof PotBlockEntity)) {
                    return BaseBlock.InteractionFeedback.CONSUME;
                }
                PotDecorations decorations2 = ((PotBlockEntity)entity2).getDecorations();
                if (this.type == PotType.DEFAULT && color == PotColor.BLANK) {
                    BlockState newState = (BlockState)((BlockState)((BlockState)Blocks.DECORATED_POT.defaultBlockState().setValue(HORIZONTAL_FACING, (Comparable)((Direction)state.getValue(HORIZONTAL_FACING)))).setValue((Property)CRACKED, (Comparable)((Boolean)state.getValue((Property)CRACKED)))).setValue((Property)WATERLOGGED, (Comparable)((Boolean)state.getValue((Property)WATERLOGGED)));
                    level.setBlock(pos, newState, 3);
                    entity2 = level.getBlockEntity(pos);
                    if (entity2 instanceof DecoratedPotBlockEntity) {
                        ((DecoratedPotBlockEntity)entity2).decorations = decorations2;
                        entity2.setChanged();
                        level.sendBlockUpdated(pos, state, state, 2);
                    }
                } else {
                    BlockState newState = (BlockState)((BlockState)((BlockState)this.type.getBlock(color).defaultBlockState().setValue(HORIZONTAL_FACING, (Comparable)((Direction)state.getValue(HORIZONTAL_FACING)))).setValue((Property)CRACKED, (Comparable)((Boolean)state.getValue((Property)CRACKED)))).setValue((Property)WATERLOGGED, (Comparable)((Boolean)state.getValue((Property)WATERLOGGED)));
                    level.setBlock(pos, newState, 3);
                    entity2 = level.getBlockEntity(pos);
                    if (entity2 instanceof PotBlockEntity) {
                        ((PotBlockEntity)entity2).updateDecorations(decorations2);
                    }
                }
                if (!player.isCreative()) {
                    stack = stack.copy();
                    stack.shrink(1);
                    player.setItemInHand(hand, stack);
                }
            }
            return BaseBlock.InteractionFeedback.SUCCESS;
        }
        if (hitSide.getAxis().isHorizontal() && stack.is(ItemTags.DECORATED_POT_INGREDIENTS) && (entity2 = level.getBlockEntity(pos)) instanceof PotBlockEntity) {
            PotBlockEntity entity3 = (PotBlockEntity)entity2;
            decorations = entity3.getDecorations();
            Optional<Item> oldItem = DecorationUtils.getDecorationItem((PotDecorations)decorations, (Direction)state.getValue(HORIZONTAL_FACING), hitSide);
            if (stack.is(oldItem.orElse(Items.BRICK))) {
                return BaseBlock.InteractionFeedback.CONSUME;
            }
            if (!level.isClientSide) {
                PotDecorations newDecorations = DecorationUtils.setDecorationItem((PotDecorations)decorations, (Direction)state.getValue(HORIZONTAL_FACING), hitSide, Optional.of(stack.getItem()));
                entity3.updateDecorations(newDecorations);
                if (!player.isCreative()) {
                    stack = stack.copy();
                    stack.shrink(1);
                    player.setItemInHand(hand, stack);
                    player.getInventory().placeItemBackInInventory(oldItem.orElse(Items.BRICK).getDefaultInstance());
                }
            }
            return BaseBlock.InteractionFeedback.SUCCESS;
        }
        decorations = level.getBlockEntity(pos);
        if (decorations instanceof PotBlockEntity) {
            PotBlockEntity entity4 = (PotBlockEntity)decorations;
            ItemStack stored = entity4.getTheItem();
            if (!stack.isEmpty() && (stored.isEmpty() || ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)stored) && stored.getCount() < stored.getMaxStackSize())) {
                entity4.wobble(DecoratedPotBlockEntity.WobbleStyle.POSITIVE);
                player.awardStat(Stats.ITEM_USED.get((Object)stack.getItem()));
                if (stored.isEmpty()) {
                    stored = player.isCreative() ? stack.copyWithCount(1) : stack.split(1);
                } else {
                    stored.grow(player.isCreative() ? 1 : stack.split(1).getCount());
                }
                entity4.setTheItem(stored);
                float fillPercentage = (float)stored.getCount() / (float)stored.getMaxStackSize();
                level.playSound(null, pos, SoundEvents.DECORATED_POT_INSERT, SoundSource.BLOCKS, 1.0f, 0.7f + 0.5f * fillPercentage);
                if (level instanceof ServerLevel) {
                    ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.DUST_PLUME, (double)pos.getX() + 0.5, (double)pos.getY() + 1.2, (double)pos.getZ() + 0.5, 7, 0.0, 0.0, 0.0, 0.0);
                }
                entity4.setChanged();
            } else {
                level.playSound(null, pos, SoundEvents.DECORATED_POT_INSERT_FAIL, SoundSource.BLOCKS, 1.0f, 1.0f);
                entity4.wobble(DecoratedPotBlockEntity.WobbleStyle.NEGATIVE);
            }
        }
        level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, pos);
        return BaseBlock.InteractionFeedback.SUCCESS;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        boolean waterlogged = context.getLevel().getFluidState(context.getClickedPos()).is((Fluid)Fluids.WATER);
        return (BlockState)((BlockState)this.defaultBlockState().setValue(HORIZONTAL_FACING, (Comparable)context.getHorizontalDirection())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged));
    }

    public void onRemove(BlockState oldState, Level level, BlockPos pos, BlockState newState, boolean bl) {
        Containers.dropContentsOnDestroy((BlockState)oldState, (BlockState)newState, (Level)level, (BlockPos)pos);
        super.onRemove(oldState, level, pos, newState, bl);
    }

    protected BlockState updateShape(BlockState state, LevelReader level, ScheduledTickAccess tickAccess, BlockPos pos, Direction side, BlockPos neighborPos, BlockState neighborState, RandomSource random) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            tickAccess.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay(level));
        }
        return super.updateShape(state, level, tickAccess, pos, side, neighborPos, neighborState, random);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{HORIZONTAL_FACING, CRACKED, WATERLOGGED});
        super.createBlockStateDefinition(builder);
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.type.getShape().getUnderlying();
    }

    public BlockEntity createNewBlockEntity(BlockPos pos, BlockState state) {
        return new PotBlockEntity(this.type, pos, state);
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        Object object = builder.getOptionalParameter(LootContextParams.BLOCK_ENTITY);
        if (object instanceof PotBlockEntity) {
            PotBlockEntity entity = (PotBlockEntity)((Object)object);
            builder.withDynamicDrop(DecoratedPotBlock.SHERDS_DYNAMIC_DROP_ID, consumer -> {
                entity.getDecorations().ordered().stream().map(Item::getDefaultInstance).forEach(consumer);
                for (int i = 0; i < this.type.getExtraBricks(); ++i) {
                    consumer.accept(Items.BRICK.getDefaultInstance());
                }
            });
        }
        return super.getDrops(state, builder);
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        ItemStack stack = player.getMainHandItem();
        if (stack.is(ItemTags.BREAKS_DECORATED_POTS) && !EnchantmentHelper.hasTag((ItemStack)stack, (TagKey)EnchantmentTags.PREVENTS_DECORATED_POT_SHATTERING)) {
            state = (BlockState)state.setValue((Property)CRACKED, (Comparable)Boolean.valueOf(true));
            level.setBlock(pos, state, 4);
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public SoundType getSoundType(BlockState state) {
        return (Boolean)state.getValue((Property)CRACKED) != false ? SoundType.DECORATED_POT_CRACKED : SoundType.DECORATED_POT;
    }

    protected void appendItemInformation(ItemStack stack, Consumer<Component> info, boolean advanced) {
        super.appendItemInformation(stack, info, advanced);
        PotDecorations decorations = (PotDecorations)stack.get(DataComponents.POT_DECORATIONS);
        if (decorations != null && !decorations.equals((Object)PotDecorations.EMPTY)) {
            info.accept(CommonComponents.EMPTY);
            info.accept((Component)TextComponents.string((String)"Patterns:").color(ChatFormatting.GRAY).get());
            info.accept((Component)TextComponents.string((String)" Front: ").color(ChatFormatting.DARK_GRAY).append(decorations.front().orElse(Items.BRICK).getName().plainCopy().withStyle(decorations.front().isEmpty() ? ChatFormatting.GRAY : ChatFormatting.GOLD)).get());
            info.accept((Component)TextComponents.string((String)" Left: ").color(ChatFormatting.DARK_GRAY).append(decorations.left().orElse(Items.BRICK).getName().plainCopy().withStyle(decorations.left().isEmpty() ? ChatFormatting.GRAY : ChatFormatting.GOLD)).get());
            info.accept((Component)TextComponents.string((String)" Right: ").color(ChatFormatting.DARK_GRAY).append(decorations.right().orElse(Items.BRICK).getName().plainCopy().withStyle(decorations.right().isEmpty() ? ChatFormatting.GRAY : ChatFormatting.GOLD)).get());
            info.accept((Component)TextComponents.string((String)" Back: ").color(ChatFormatting.DARK_GRAY).append(decorations.back().orElse(Items.BRICK).getName().plainCopy().withStyle(decorations.back().isEmpty() ? ChatFormatting.GRAY : ChatFormatting.GOLD)).get());
        }
    }

    protected ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state, boolean includeData) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof PotBlockEntity) {
            PotBlockEntity entity = (PotBlockEntity)blockEntity;
            return entity.itemFromDecorations();
        }
        return super.getCloneItemStack(level, pos, state, includeData);
    }

    public void onProjectileHit(Level level, BlockState state, BlockHitResult blockHitResult, Projectile projectile) {
        BlockPos pos = blockHitResult.getBlockPos();
        if (level instanceof ServerLevel && projectile.mayInteract((ServerLevel)level, pos) && projectile.mayBreak((ServerLevel)level)) {
            level.setBlock(pos, (BlockState)state.setValue((Property)CRACKED, (Comparable)Boolean.valueOf(true)), 4);
            level.destroyBlock(pos, true, (Entity)projectile);
        }
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        return AbstractContainerMenu.getRedstoneSignalFromBlockEntity((BlockEntity)level.getBlockEntity(pos));
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.INVISIBLE;
    }

    public boolean triggerEvent(BlockState state, Level level, BlockPos pos, int identifier, int data) {
        BlockEntity entity;
        return super.triggerEvent(state, level, pos, identifier, data) || (entity = level.getBlockEntity(pos)) != null && entity.triggerEvent(identifier, data);
    }
}

