/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.pottery.content;

import java.util.Locale;
import java.util.function.Supplier;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.DecoratedPotPattern;

public enum PotColor {
    BLANK(null, 0, 100, 0, null),
    WHITE("White", 0, 0, 25, () -> Ingredient.of((ItemLike)Items.WHITE_DYE)),
    ORANGE("Orange", 0, 130, 0, () -> Ingredient.of((ItemLike)Items.ORANGE_DYE)),
    MAGENTA("Magenta", -70, 115, 0, () -> Ingredient.of((ItemLike)Items.MAGENTA_DYE)),
    LIGHT_BLUE("Light Blue", -170, 110, 0, () -> Ingredient.of((ItemLike)Items.LIGHT_BLUE_DYE)),
    YELLOW("Yellow", 35, 120, 0, () -> Ingredient.of((ItemLike)Items.YELLOW_DYE)),
    LIME("Lime", 75, 125, 0, () -> Ingredient.of((ItemLike)Items.LIME_DYE)),
    PINK("Pink", -35, 115, 5, () -> Ingredient.of((ItemLike)Items.PINK_DYE)),
    GRAY("Gray", 0, 0, -25, () -> Ingredient.of((ItemLike)Items.GRAY_DYE)),
    LIGHT_GRAY("Light Gray", 0, 0, 0, () -> Ingredient.of((ItemLike)Items.LIGHT_GRAY_DYE)),
    CYAN("Cyan", 155, 100, 0, () -> Ingredient.of((ItemLike)Items.CYAN_DYE)),
    PURPLE("Purple", -95, 120, 0, () -> Ingredient.of((ItemLike)Items.PURPLE_DYE)),
    BLUE("Blue", -145, 115, -5, () -> Ingredient.of((ItemLike)Items.BLUE_DYE)),
    BROWN("Brown", 0, 125, -30, () -> Ingredient.of((ItemLike)Items.BROWN_DYE)),
    GREEN("Green", 95, 120, -20, () -> Ingredient.of((ItemLike)Items.GREEN_DYE)),
    RED("Red", -10, 140, -20, () -> Ingredient.of((ItemLike)Items.RED_DYE)),
    BLACK("Black", 0, 0, -60, () -> Ingredient.of((ItemLike)Items.BLACK_DYE));

    private final String identifier;
    private final String translation;
    private final int hueShift;
    private final int saturationShift;
    private final int brightnessShift;
    private final Supplier<Ingredient> dyeIngredient;

    private PotColor(String translation, int hueShift, int saturationShift, int brightnessShift, Supplier<Ingredient> dyeIngredient) {
        this.dyeIngredient = dyeIngredient;
        this.identifier = this.name().toLowerCase(Locale.ROOT);
        this.translation = translation;
        this.hueShift = hueShift;
        this.saturationShift = saturationShift;
        this.brightnessShift = brightnessShift;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getTranslation() {
        return this.translation;
    }

    public int getHueShift() {
        return this.hueShift;
    }

    public int getSaturationShift() {
        return this.saturationShift;
    }

    public int getBrightnessShift() {
        return this.brightnessShift;
    }

    public Ingredient getDyeIngredient() {
        return this.dyeIngredient.get();
    }

    public ResourceLocation getPatternLocation(ResourceKey<DecoratedPotPattern> key) {
        ResourceLocation texture = ((Material)Sheets.DECORATED_POT_MATERIALS.get(key)).texture();
        if (this == BLANK) {
            return texture;
        }
        if (key.location().getNamespace().equals("minecraft")) {
            return ResourceLocation.fromNamespaceAndPath((String)"pottery", (String)("patterns/" + this.getIdentifier() + "/" + texture.getPath().substring(texture.getPath().lastIndexOf(47) + 1)));
        }
        return texture;
    }

    public static DyeColor dyeForColor(PotColor color) {
        return switch (color.ordinal()) {
            case 1 -> DyeColor.WHITE;
            case 2 -> DyeColor.ORANGE;
            case 3 -> DyeColor.MAGENTA;
            case 4 -> DyeColor.LIGHT_BLUE;
            case 5 -> DyeColor.YELLOW;
            case 6 -> DyeColor.LIME;
            case 7 -> DyeColor.PINK;
            case 8 -> DyeColor.GRAY;
            case 9 -> DyeColor.LIGHT_GRAY;
            case 10 -> DyeColor.CYAN;
            case 11 -> DyeColor.PURPLE;
            case 12 -> DyeColor.BLUE;
            case 13 -> DyeColor.BROWN;
            case 14 -> DyeColor.GREEN;
            case 15 -> DyeColor.RED;
            case 16 -> DyeColor.BLACK;
            default -> null;
        };
    }

    public static PotColor colorForDye(DyeColor dye) {
        return switch (dye) {
            case DyeColor.WHITE -> WHITE;
            case DyeColor.ORANGE -> ORANGE;
            case DyeColor.MAGENTA -> MAGENTA;
            case DyeColor.LIGHT_BLUE -> LIGHT_BLUE;
            case DyeColor.YELLOW -> YELLOW;
            case DyeColor.LIME -> LIME;
            case DyeColor.PINK -> PINK;
            case DyeColor.GRAY -> GRAY;
            case DyeColor.LIGHT_GRAY -> LIGHT_GRAY;
            case DyeColor.CYAN -> CYAN;
            case DyeColor.PURPLE -> PURPLE;
            case DyeColor.BLUE -> BLUE;
            case DyeColor.BROWN -> BROWN;
            case DyeColor.GREEN -> GREEN;
            case DyeColor.RED -> RED;
            case DyeColor.BLACK -> BLACK;
            default -> null;
        };
    }
}

