/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.pottery.generators;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.supermartijn642.core.generator.ResourceCache;
import com.supermartijn642.core.generator.ResourceGenerator;
import com.supermartijn642.core.generator.ResourceType;
import com.supermartijn642.core.registry.Registries;
import com.supermartijn642.pottery.content.PotColor;
import com.supermartijn642.pottery.content.PotType;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class PotteryRecipeGenerator
extends ResourceGenerator {
    private final Map<ResourceLocation, RecipeBuilder> recipes = new LinkedHashMap<ResourceLocation, RecipeBuilder>();

    public PotteryRecipeGenerator(ResourceCache cache) {
        super("pottery", cache);
    }

    public String getName() {
        return this.modName + " Recipe Generator";
    }

    public RecipeBuilder recipe(String location) {
        this.cache.trackToBeGeneratedResource(ResourceType.DATA, this.modid, "recipe", location, ".json");
        return this.recipes.computeIfAbsent(ResourceLocation.fromNamespaceAndPath((String)this.modid, (String)location), i -> new RecipeBuilder());
    }

    public void generate() {
        HolderLookup.RegistryLookup lookup = ResourceGenerator.registryAccess.lookupOrThrow(net.minecraft.core.registries.Registries.ITEM);
        for (PotType type : PotType.values()) {
            for (PotColor color : PotColor.values()) {
                RecipeBuilder recipe = this.recipe(type.getIdentifier(color));
                switch (type) {
                    case DEFAULT: {
                        recipe.pattern(" # ", "# #", " # ").sherds(7, 3, 5, 1);
                        break;
                    }
                    case BASE: {
                        recipe.pattern("###", " # ").sherds(4, 0, 2, 1);
                        break;
                    }
                    case SEALED: {
                        recipe.pattern(" P ", "# #", "#B#").sherds(8, 6, 5, 3).input('P', new ItemLike[]{Items.STONE_PRESSURE_PLATE, Items.POLISHED_BLACKSTONE_PRESSURE_PLATE}).input('B', new ItemLike[]{Items.BRICK});
                        break;
                    }
                    case WIDE: {
                        recipe.pattern("# #", "#B#").sherds(5, 3, 2, 0).input('B', new ItemLike[]{Items.BRICK});
                        break;
                    }
                    case TALL: {
                        recipe.pattern("# #", "# #", " B ").sherds(5, 3, 2, 0).input('B', new ItemLike[]{Items.BRICK});
                        break;
                    }
                    case SMALL: {
                        recipe.pattern(" # ", "###").sherds(4, 3, 5, 1);
                    }
                }
                if (color != PotColor.BLANK) {
                    recipe.dye(color.getDyeIngredient());
                }
                recipe.input('#', (TagKey<Item>)ItemTags.DECORATED_POT_INGREDIENTS).output(type.getItem(color));
            }
        }
    }

    public void save() {
        for (Map.Entry<ResourceLocation, RecipeBuilder> entry : this.recipes.entrySet()) {
            ResourceLocation location = entry.getKey();
            RecipeBuilder recipe = entry.getValue();
            JsonObject json = new JsonObject();
            json.addProperty("type", "pottery:pot");
            JsonArray sherds = new JsonArray(4);
            sherds.add((Number)recipe.sherdIndices[0]);
            sherds.add((Number)recipe.sherdIndices[1]);
            sherds.add((Number)recipe.sherdIndices[2]);
            sherds.add((Number)recipe.sherdIndices[3]);
            json.add("sherds", (JsonElement)sherds);
            if (recipe.dyeIngredient != null) {
                json.add("dye_ingredient", (JsonElement)Ingredient.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)recipe.dyeIngredient).getOrThrow());
            }
            JsonObject recipeJson = new JsonObject();
            recipeJson.addProperty("show_notification", Boolean.valueOf(true));
            JsonArray pattern = new JsonArray();
            Arrays.stream(recipe.pattern).forEach(arg_0 -> ((JsonArray)pattern).add(arg_0));
            recipeJson.add("pattern", (JsonElement)pattern);
            JsonObject keys = new JsonObject();
            recipe.inputs.forEach((key, ingredient) -> {
                if (ingredient.size() == 1) {
                    keys.addProperty(key.toString(), (String)ingredient.getFirst());
                } else {
                    JsonArray arr = new JsonArray(ingredient.size());
                    ingredient.forEach(arg_0 -> ((JsonArray)arr).add(arg_0));
                    keys.add(key.toString(), (JsonElement)arr);
                }
            });
            recipeJson.add("key", (JsonElement)keys);
            JsonObject result = new JsonObject();
            result.addProperty("id", Registries.ITEMS.getIdentifier((Object)recipe.output).toString());
            recipeJson.add("result", (JsonElement)result);
            json.add("recipe", (JsonElement)recipeJson);
            this.cache.saveJsonResource(ResourceType.DATA, json, location.getNamespace(), "recipe", location.getPath());
        }
    }

    private static class RecipeBuilder {
        private String[] pattern;
        private int[] sherdIndices;
        private final Map<Character, List<String>> inputs = new LinkedHashMap<Character, List<String>>();
        private Ingredient dyeIngredient;
        private Item output;

        private RecipeBuilder() {
        }

        public RecipeBuilder pattern(String ... pattern) {
            if (pattern.length == 0 || pattern.length > 3) {
                throw new IllegalArgumentException("Pattern must consist of 1 to 3 lines!");
            }
            int width = pattern[0].length();
            for (String s : pattern) {
                if (s.length() != width) {
                    throw new IllegalArgumentException("All lines in the pattern must have the same length!");
                }
                if (s.length() != 0 && s.length() <= 3) continue;
                throw new IllegalArgumentException("Pattern must have a width of 1 to 3 characters!");
            }
            this.pattern = pattern;
            return this;
        }

        public RecipeBuilder sherds(int front, int left, int right, int back) {
            this.sherdIndices = new int[]{front, left, right, back};
            return this;
        }

        private RecipeBuilder input(char key, String ... input) {
            if (this.inputs.put(Character.valueOf(key), Arrays.asList(input)) != null) {
                throw new IllegalArgumentException("Duplicate input for character '" + key + "'!");
            }
            return this;
        }

        public RecipeBuilder input(char key, ItemLike ... items) {
            return this.input(key, (String[])Arrays.stream(items).map(ItemLike::asItem).map(arg_0 -> ((Registries.Registry)Registries.ITEMS).getIdentifier(arg_0)).map(ResourceLocation::toString).toArray(String[]::new));
        }

        public RecipeBuilder input(char key, TagKey<Item> tag) {
            return this.input(key, "#" + String.valueOf(tag.location()));
        }

        public RecipeBuilder dye(Ingredient ingredient) {
            this.dyeIngredient = ingredient;
            return this;
        }

        public RecipeBuilder dye(Item dye) {
            this.dye(Ingredient.of((ItemLike)dye));
            return this;
        }

        public RecipeBuilder output(Item output) {
            this.output = output;
            return this;
        }
    }
}

