/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.config;

import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.puffish.skillsmod.api.config.ConfigContext;
import net.puffish.skillsmod.api.json.JsonElement;
import net.puffish.skillsmod.api.util.Problem;
import net.puffish.skillsmod.api.util.Result;
import net.puffish.skillsmod.config.GeneralConfig;
import net.puffish.skillsmod.config.experience.ExperienceConfig;
import net.puffish.skillsmod.config.skill.SkillConnectionsConfig;
import net.puffish.skillsmod.config.skill.SkillDefinitionsConfig;
import net.puffish.skillsmod.config.skill.SkillsConfig;
import net.puffish.skillsmod.util.DisposeContext;

public class CategoryConfig {
    private final ResourceLocation id;
    private final GeneralConfig general;
    private final SkillDefinitionsConfig definitions;
    private final SkillsConfig skills;
    private final SkillConnectionsConfig connections;
    private final Optional<ExperienceConfig> optExperience;

    private CategoryConfig(ResourceLocation id, GeneralConfig general, SkillDefinitionsConfig definitions, SkillsConfig skills, SkillConnectionsConfig connections, Optional<ExperienceConfig> optExperience) {
        this.id = id;
        this.general = general;
        this.definitions = definitions;
        this.skills = skills;
        this.connections = connections;
        this.optExperience = optExperience;
    }

    public static Result<CategoryConfig, Problem> parse(ResourceLocation id, JsonElement generalElement, JsonElement definitionsElement, JsonElement skillsElement, JsonElement connectionsElement, Optional<JsonElement> optExperienceElement, ConfigContext context) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        Optional<GeneralConfig> optGeneral = GeneralConfig.parse(generalElement, context).ifFailure(problems::add).getSuccess();
        Optional<ExperienceConfig> optExperience = optExperienceElement.flatMap(experience -> ExperienceConfig.parse(experience, context).ifFailure(problems::add).getSuccess().flatMap(Function.identity()));
        Optional<SkillDefinitionsConfig> optDefinitions = SkillDefinitionsConfig.parse(definitionsElement, context).ifFailure(problems::add).getSuccess();
        Optional optSkills = optDefinitions.flatMap(definitions -> SkillsConfig.parse(skillsElement, definitions, context).ifFailure(problems::add).getSuccess());
        Optional optConnections = optSkills.flatMap(skills -> SkillConnectionsConfig.parse(connectionsElement, skills, context).ifFailure(problems::add).getSuccess());
        if (problems.isEmpty()) {
            return Result.success(new CategoryConfig(id, optGeneral.orElseThrow(), optDefinitions.orElseThrow(), (SkillsConfig)optSkills.orElseThrow(), (SkillConnectionsConfig)optConnections.orElseThrow(), optExperience));
        }
        return Result.failure(Problem.combine(problems));
    }

    public void dispose(DisposeContext context) {
        this.definitions.dispose(context);
        this.optExperience.ifPresent(experience -> experience.dispose(context));
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public GeneralConfig getGeneral() {
        return this.general;
    }

    public SkillDefinitionsConfig getDefinitions() {
        return this.definitions;
    }

    public SkillsConfig getSkills() {
        return this.skills;
    }

    public SkillConnectionsConfig getConnections() {
        return this.connections;
    }

    public Optional<ExperienceConfig> getExperience() {
        return this.optExperience;
    }
}

