/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.experience.source.builtin.util;

import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.puffish.skillsmod.api.config.ConfigContext;
import net.puffish.skillsmod.api.json.JsonElement;
import net.puffish.skillsmod.api.json.JsonObject;
import net.puffish.skillsmod.api.util.Problem;
import net.puffish.skillsmod.api.util.Result;
import net.puffish.skillsmod.util.LegacyUtils;

public record AntiFarmingPerChunk(int limitPerChunk, int resetAfterSeconds) {
    public static Result<Optional<AntiFarmingPerChunk>, Problem> parse(JsonElement rootElement, ConfigContext context) {
        return rootElement.getAsObject().andThen(LegacyUtils.wrapNoUnused(rootObject -> AntiFarmingPerChunk.parse(rootObject, context), context));
    }

    private static Result<Optional<AntiFarmingPerChunk>, Problem> parse(JsonObject rootObject, ConfigContext context) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        Boolean enabled = LegacyUtils.deprecated(() -> rootObject.getBoolean("enabled"), 3, context).orElse(true);
        Optional<Integer> optLimitPerChunk = rootObject.getInt("limit_per_chunk").ifFailure(problems::add).getSuccess();
        Optional<Integer> optResetAfterSeconds = rootObject.getInt("reset_after_seconds").ifFailure(problems::add).getSuccess();
        if (problems.isEmpty()) {
            if (enabled.booleanValue()) {
                return Result.success(Optional.of(new AntiFarmingPerChunk(optLimitPerChunk.orElseThrow(), optResetAfterSeconds.orElseThrow())));
            }
            return Result.success(Optional.empty());
        }
        return Result.failure(Problem.combine(problems));
    }

    public static class Data {
        private final Map<AntiFarmingPerChunk, LongList> antiFarmingData = new HashMap<AntiFarmingPerChunk, LongList>();

        public boolean tryIncrement(AntiFarmingPerChunk antiFarming) {
            LongList data = this.antiFarmingData.computeIfAbsent(antiFarming, key -> new LongArrayList());
            if (data.size() < antiFarming.limitPerChunk()) {
                data.add(System.currentTimeMillis() + (long)antiFarming.resetAfterSeconds() * 1000L);
                return true;
            }
            return false;
        }

        public void removeOutdated() {
            long currentTime = System.currentTimeMillis();
            this.antiFarmingData.values().removeIf(data -> {
                data.removeIf(time -> time < currentTime);
                return data.isEmpty();
            });
        }
    }
}

