/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.impl.json;

import com.google.gson.JsonElement;
import net.puffish.skillsmod.api.json.JsonArray;
import net.puffish.skillsmod.api.json.JsonObject;
import net.puffish.skillsmod.api.json.JsonPath;
import net.puffish.skillsmod.api.util.Problem;
import net.puffish.skillsmod.api.util.Result;
import net.puffish.skillsmod.impl.json.JsonArrayImpl;
import net.puffish.skillsmod.impl.json.JsonObjectImpl;
import net.puffish.skillsmod.util.JsonPathFailure;

public class JsonElementImpl
implements net.puffish.skillsmod.api.json.JsonElement {
    private final JsonElement json;
    private final JsonPath path;

    public JsonElementImpl(JsonElement json, JsonPath path) {
        this.json = json;
        this.path = path;
    }

    @Override
    public Result<JsonObject, Problem> getAsObject() {
        try {
            return Result.success(new JsonObjectImpl(this.json.getAsJsonObject(), this.path));
        }
        catch (Exception e) {
            return Result.failure(JsonPathFailure.expectedToBe(this.path, "an object"));
        }
    }

    @Override
    public Result<JsonArray, Problem> getAsArray() {
        try {
            return Result.success(new JsonArrayImpl(this.json.getAsJsonArray(), this.path));
        }
        catch (Exception e) {
            return Result.failure(JsonPathFailure.expectedToBe(this.path, "an array"));
        }
    }

    @Override
    public Result<String, Problem> getAsString() {
        try {
            return Result.success(this.json.getAsString());
        }
        catch (Exception e) {
            return Result.failure(JsonPathFailure.expectedToBe(this.path, "a string"));
        }
    }

    @Override
    public Result<Float, Problem> getAsFloat() {
        try {
            return Result.success(Float.valueOf(this.json.getAsFloat()));
        }
        catch (Exception e) {
            return Result.failure(JsonPathFailure.expectedToBe(this.path, "a float"));
        }
    }

    @Override
    public Result<Double, Problem> getAsDouble() {
        try {
            return Result.success(this.json.getAsDouble());
        }
        catch (Exception e) {
            return Result.failure(JsonPathFailure.expectedToBe(this.path, "a double"));
        }
    }

    @Override
    public Result<Integer, Problem> getAsInt() {
        try {
            return Result.success(this.json.getAsInt());
        }
        catch (Exception e) {
            return Result.failure(JsonPathFailure.expectedToBe(this.path, "an int"));
        }
    }

    @Override
    public Result<Boolean, Problem> getAsBoolean() {
        try {
            return Result.success(this.json.getAsBoolean());
        }
        catch (Exception e) {
            return Result.failure(JsonPathFailure.expectedToBe(this.path, "a boolean"));
        }
    }

    @Override
    public JsonElement getJson() {
        return this.json;
    }

    @Override
    public JsonPath getPath() {
        return this.path;
    }
}

