/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.mixin;

import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.puffish.skillsmod.access.DamageSourceAccess;
import net.puffish.skillsmod.access.WorldChunkAccess;
import net.puffish.skillsmod.api.SkillsAPI;
import net.puffish.skillsmod.experience.source.builtin.DealDamageExperienceSource;
import net.puffish.skillsmod.experience.source.builtin.HealExperienceSource;
import net.puffish.skillsmod.experience.source.builtin.KillEntityExperienceSource;
import net.puffish.skillsmod.experience.source.builtin.SharedKillEntityExperienceSource;
import net.puffish.skillsmod.experience.source.builtin.util.AntiFarmingPerChunk;
import net.puffish.skillsmod.experience.source.builtin.util.AntiFarmingPerEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin {
    @Unique
    private int entityDroppedXp = 0;
    @Unique
    private final Map<ServerPlayer, Float> damageShare = new WeakHashMap<ServerPlayer, Float>();
    @Unique
    private final AntiFarmingPerEntity.Data antiFarmingData = new AntiFarmingPerEntity.Data();

    @Inject(method={"heal(F)V"}, at={@At(value="TAIL")})
    private void injectAtHeal(float amount, CallbackInfo ci) {
        LivingEntity livingEntity;
        if (amount > 0.0f && (livingEntity = (LivingEntity)this) instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            SkillsAPI.updateExperienceSources(player, HealExperienceSource.class, experienceSource -> experienceSource.getValue(player, amount));
        }
    }

    @Inject(method={"actuallyHurt(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/damagesource/DamageSource;F)V"}, at={@At(value="TAIL")})
    private void injectAtApplyDamage(ServerLevel world, DamageSource source, float damage, CallbackInfo ci) {
        LivingEntity entity = (LivingEntity)this;
        ItemStack weapon = ((DamageSourceAccess)source).getWeapon().orElse(ItemStack.EMPTY);
        Entity entity2 = source.getEntity();
        if (entity2 instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity2;
            this.damageShare.compute(player, (key, value) -> {
                if (value == null) {
                    return Float.valueOf(damage);
                }
                return Float.valueOf(value.floatValue() + damage);
            });
            this.antiFarmingData.removeOutdated();
            SkillsAPI.updateExperienceSources(player, DealDamageExperienceSource.class, experienceSource -> {
                float limitedDamage = experienceSource.getAntiFarming().map(antiFarming -> Float.valueOf(this.antiFarmingData.addAndLimit((AntiFarmingPerEntity)antiFarming, damage))).orElse(Float.valueOf(damage)).floatValue();
                if (limitedDamage > 1.0E-5f) {
                    return experienceSource.getValue(player, entity, weapon, limitedDamage, source);
                }
                return 0;
            });
        }
    }

    @Inject(method={"dropAllDeathLoot(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/damagesource/DamageSource;)V"}, at={@At(value="TAIL")})
    private void injectAtDrop(ServerLevel world, DamageSource source, CallbackInfo ci) {
        Entity entity = source.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            LivingEntity entity2 = (LivingEntity)this;
            ItemStack weapon = ((DamageSourceAccess)source).getWeapon().orElse(ItemStack.EMPTY);
            AntiFarmingPerChunk.Data antiFarmingData = ((WorldChunkAccess)entity2.level().getChunkAt(entity2.blockPosition())).getAntiFarmingData();
            antiFarmingData.removeOutdated();
            SkillsAPI.updateExperienceSources(player, KillEntityExperienceSource.class, experienceSource -> {
                if (experienceSource.getAntiFarming().map(antiFarmingData::tryIncrement).orElse(true).booleanValue()) {
                    return experienceSource.getValue(player, entity2, weapon, source, this.entityDroppedXp);
                }
                return 0;
            });
            Set<Map.Entry<ServerPlayer, Float>> entries = this.damageShare.entrySet();
            double totalDamage = entries.stream().mapToDouble(Map.Entry::getValue).sum();
            for (Map.Entry<ServerPlayer, Float> entry : entries) {
                SkillsAPI.updateExperienceSources(entry.getKey(), SharedKillEntityExperienceSource.class, experienceSource -> {
                    if (experienceSource.getAntiFarming().map(antiFarmingData::tryIncrement).orElse(true).booleanValue()) {
                        return experienceSource.getValue((ServerPlayer)entry.getKey(), entity2, weapon, source, this.entityDroppedXp, totalDamage, entries.size(), (double)((Float)entry.getValue()).floatValue() / totalDamage);
                    }
                    return 0;
                });
            }
        }
    }

    @ModifyArg(method={"dropExperience(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/entity/Entity;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/ExperienceOrb;award(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/phys/Vec3;I)V"), index=2)
    private int injectAtDropExperience(int droppedXp) {
        this.entityDroppedXp = droppedXp;
        return droppedXp;
    }
}

