/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.server.data;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.puffish.skillsmod.api.Skill;
import net.puffish.skillsmod.config.CategoryConfig;
import net.puffish.skillsmod.config.GeneralConfig;
import net.puffish.skillsmod.config.skill.SkillConfig;
import net.puffish.skillsmod.config.skill.SkillDefinitionConfig;
import net.puffish.skillsmod.config.skill.SkillRewardConfig;
import net.puffish.skillsmod.impl.rewards.RewardUpdateContextImpl;

public class CategoryData {
    private final Set<String> unlockedSkills;
    private boolean unlocked;
    private int extraPoints;
    private int earnedExperience;

    private CategoryData(Set<String> unlockedSkills, boolean unlocked, int extraPoints, int earnedExperience) {
        this.unlockedSkills = unlockedSkills;
        this.unlocked = unlocked;
        this.extraPoints = extraPoints;
        this.earnedExperience = earnedExperience;
    }

    public static CategoryData create(GeneralConfig general) {
        return new CategoryData(new HashSet<String>(), general.isUnlockedByDefault(), general.getStartingPoints(), 0);
    }

    public static CategoryData read(CompoundTag nbt) {
        boolean unlocked = nbt.getBoolean("unlocked");
        int points = nbt.getInt("points");
        int experience = nbt.getInt("experience");
        HashSet<String> unlockedSkills = new HashSet<String>();
        ListTag unlockedNbt = nbt.getList("unlocked_skills", 8);
        for (Tag elementNbt : unlockedNbt) {
            if (!(elementNbt instanceof StringTag)) continue;
            StringTag stringNbt = (StringTag)elementNbt;
            unlockedSkills.add(stringNbt.getAsString());
        }
        return new CategoryData(unlockedSkills, unlocked, points, experience);
    }

    public CompoundTag writeNbt(CompoundTag nbt) {
        nbt.putBoolean("unlocked", this.unlocked);
        nbt.putInt("points", this.extraPoints);
        nbt.putInt("experience", this.earnedExperience);
        ListTag unlockedNbt = new ListTag();
        for (String skill : this.unlockedSkills) {
            unlockedNbt.add((Object)StringTag.valueOf((String)skill));
        }
        nbt.put("unlocked_skills", (Tag)unlockedNbt);
        return nbt;
    }

    public Skill.State getSkillState(CategoryConfig category, SkillConfig skill, SkillDefinitionConfig definition) {
        if (this.unlockedSkills.contains(skill.getId())) {
            return Skill.State.UNLOCKED;
        }
        if (category.getConnections().getExclusive().getNeighborsFor(skill.getId()).map(neighbors -> neighbors.stream().anyMatch(this.unlockedSkills::contains)).orElse(false).booleanValue()) {
            return Skill.State.EXCLUDED;
        }
        if (category.getConnections().getNormal().getNeighborsFor(skill.getId()).map(neighbors -> neighbors.stream().filter(this.unlockedSkills::contains).count()).orElse(0L) >= (long)definition.getRequiredSkills()) {
            return this.canAfford(category, definition) ? Skill.State.AFFORDABLE : Skill.State.AVAILABLE;
        }
        if (skill.isRoot()) {
            if (category.getGeneral().isExclusiveRoot() && this.unlockedSkills.stream().flatMap(skillId -> category.getSkills().getById((String)skillId).stream()).anyMatch(SkillConfig::isRoot)) {
                return Skill.State.LOCKED;
            }
            return this.canAfford(category, definition) ? Skill.State.AFFORDABLE : Skill.State.AVAILABLE;
        }
        return Skill.State.LOCKED;
    }

    private boolean canAfford(CategoryConfig category, SkillDefinitionConfig definition) {
        return this.getPointsLeft(category) >= Math.max(definition.getRequiredPoints(), definition.getCost()) && this.getSpentPoints(category) >= definition.getRequiredSpentPoints();
    }

    public boolean tryUnlockSkill(CategoryConfig category, ServerPlayer player, String skillId, boolean force) {
        return category.getSkills().getById(skillId).flatMap(skill -> {
            String definitionId = skill.getDefinitionId();
            return category.getDefinitions().getById(definitionId).map(definition -> {
                if (force || this.getSkillState(category, (SkillConfig)skill, (SkillDefinitionConfig)definition) == Skill.State.AFFORDABLE) {
                    this.unlockSkill(skillId);
                    int count = this.countUnlocked(category, definitionId);
                    for (SkillRewardConfig reward : definition.getRewards()) {
                        reward.getInstance().update(new RewardUpdateContextImpl(player, count, true));
                    }
                    return true;
                }
                return false;
            });
        }).orElse(false);
    }

    public int countUnlocked(CategoryConfig category, String definitionId) {
        return category.getDefinitions().getById(definitionId).map(definition -> category.getSkills().getAll().stream().filter(skill -> skill.getDefinitionId().equals(definitionId)).filter(skill -> this.getSkillState(category, (SkillConfig)skill, (SkillDefinitionConfig)definition) == Skill.State.UNLOCKED).count()).orElse(0L).intValue();
    }

    public void updateRewards(CategoryConfig category, ServerPlayer player, Predicate<SkillRewardConfig> predicate) {
        for (SkillDefinitionConfig definition : category.getDefinitions().getAll()) {
            int count = this.countUnlocked(category, definition.getId());
            for (SkillRewardConfig reward : definition.getRewards()) {
                if (!predicate.test(reward)) continue;
                reward.getInstance().update(new RewardUpdateContextImpl(player, count, false));
            }
        }
    }

    public void unlockSkill(String id) {
        this.unlockedSkills.add(id);
    }

    public void lockSkill(String id) {
        this.unlockedSkills.remove(id);
    }

    public void resetSkills() {
        this.unlockedSkills.clear();
    }

    public void addExperience(int experience) {
        this.earnedExperience += experience;
    }

    public Set<String> getUnlockedSkillIds() {
        return this.unlockedSkills;
    }

    public int getEarnedExperience() {
        return this.earnedExperience;
    }

    public void setEarnedExperience(int earnedExperience) {
        this.earnedExperience = earnedExperience;
    }

    public int getCurrentLevel(CategoryConfig category) {
        return category.getExperience().map(experience -> experience.getCurrentLevel(this.earnedExperience)).orElse(0);
    }

    public int getCurrentExperience(CategoryConfig category) {
        return category.getExperience().map(experience -> experience.getCurrentExperience(this.earnedExperience)).orElse(0);
    }

    public int getRequiredExperience(CategoryConfig category, int level) {
        return category.getExperience().map(experience -> experience.getExperiencePerLevel().getFunction().apply(level)).orElse(0);
    }

    public int getRequiredTotalExperience(CategoryConfig category, int level) {
        return category.getExperience().map(experience -> experience.getRequiredTotalExperience(level)).orElse(0);
    }

    public int getPointsForExperience(CategoryConfig category) {
        if (category.getExperience().isPresent()) {
            return this.getCurrentLevel(category);
        }
        return 0;
    }

    public int getSpentPoints(CategoryConfig category) {
        return this.unlockedSkills.stream().flatMap(skillId -> category.getSkills().getById((String)skillId).flatMap(skill -> category.getDefinitions().getById(skill.getDefinitionId())).stream()).mapToInt(SkillDefinitionConfig::getCost).sum();
    }

    public int getEarnedPoints(CategoryConfig category) {
        return this.getExtraPoints() + this.getPointsForExperience(category);
    }

    public int getPointsLeft(CategoryConfig category) {
        return Math.min(this.getEarnedPoints(category), category.getGeneral().getSpentPointsLimit()) - this.getSpentPoints(category);
    }

    public void addExtraPoints(int count) {
        this.extraPoints += count;
    }

    public int getExtraPoints() {
        return this.extraPoints;
    }

    public void setExtraPoints(int points) {
        this.extraPoints = points;
    }

    public boolean isUnlocked() {
        return this.unlocked;
    }

    public void setUnlocked(boolean unlocked) {
        this.unlocked = unlocked;
    }
}

