/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.util;

import com.google.common.collect.ObjectArrays;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.Locale;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.puffish.skillsmod.SkillsMod;

public class CommandUtils {
    public static void sendSuccess(CommandContext<CommandSourceStack> context, ServerPlayer player, String command, Object ... args) {
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> SkillsMod.createTranslatable("command", command + ".success", ObjectArrays.concat((Object[])args, (Object)player.getDisplayName())), true);
    }

    public static void sendSuccess(CommandContext<CommandSourceStack> context, Collection<ServerPlayer> players, String command, Object ... args) {
        if (players.size() == 1) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> SkillsMod.createTranslatable("command", command + ".success.single", ObjectArrays.concat((Object[])args, (Object)((ServerPlayer)players.iterator().next()).getDisplayName())), true);
        } else {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> SkillsMod.createTranslatable("command", command + ".success.multiple", ObjectArrays.concat((Object[])args, (Object)players.size())), true);
        }
    }

    public static void suggestIdentifiers(Iterable<ResourceLocation> ids, SuggestionsBuilder builder) {
        String remaining = builder.getRemaining().toLowerCase(Locale.ROOT);
        boolean hasColon = remaining.indexOf(58) != -1;
        for (ResourceLocation id : ids) {
            if (hasColon) {
                if (!SharedSuggestionProvider.matchesSubStr((String)remaining, (String)id.toString())) continue;
                builder.suggest(id.toString());
                continue;
            }
            if (SharedSuggestionProvider.matchesSubStr((String)remaining, (String)id.getNamespace())) {
                builder.suggest(id.toString());
                continue;
            }
            if (!id.getNamespace().equals("puffish_skills") || !SharedSuggestionProvider.matchesSubStr((String)remaining, (String)id.getPath())) continue;
            builder.suggest(id.toString());
        }
    }
}

