/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.pumpkillagersquest_common_forge.util;

import com.mojang.datafixers.util.Pair;
import com.natamus.collective_common_forge.data.GlobalVariables;
import com.natamus.collective_common_forge.functions.EntityFunctions;
import com.natamus.collective_common_forge.schematic.ParseSchematicFile;
import com.natamus.collective_common_forge.schematic.ParsedSchematicObject;
import com.natamus.pumpkillagersquest_common_forge.events.rendering.ClientRenderEvent;
import com.natamus.pumpkillagersquest_common_forge.pumpkillager.Prisoner;
import com.natamus.pumpkillagersquest_common_forge.util.SpookyHeads;
import com.natamus.pumpkillagersquest_common_forge.util.Util;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.horse.SkeletonHorse;
import net.minecraft.world.entity.animal.horse.ZombieHorse;
import net.minecraft.world.entity.monster.Husk;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;

public class GenerateStructure {
    public static void generatePrisonerCamp(Level level, Player player, BlockPos cPos, int pasteNBlocksAboveSurface) {
        MinecraftServer minecraftServer = level.getServer();
        BlockPos centerPos = cPos.immutable();
        ChunkPos chunkPos = level.getChunkAt(centerPos).getPos();
        for (int x = -2; x <= 2; ++x) {
            for (int z = -2; z <= 2; ++z) {
                LevelChunk levelChunk = level.getChunk(chunkPos.x + x, chunkPos.z + z);
                levelChunk.postProcessGeneration((ServerLevel)level);
            }
        }
        boolean isPeaceful = minecraftServer.getWorldData().getDifficulty().equals((Object)Difficulty.PEACEFUL);
        InputStream schematicInputstream = Util.getSchematicsInputStream(minecraftServer, "floating_prisoner_camp");
        if (schematicInputstream == null) {
            System.out.println("[Pumpkillager's Quest] Error generating prisoner camp: inputstream is null.");
            return;
        }
        ParsedSchematicObject parsedSchematicObject = ParseSchematicFile.getParsedSchematicObject((InputStream)schematicInputstream, (Level)level, (BlockPos)centerPos, (int)pasteNBlocksAboveSurface, (boolean)false);
        if (!parsedSchematicObject.parsedCorrectly) {
            System.out.println("[Pumpkillager's Quest] Error generating prisoner camp: schematic object didn't parse.");
            return;
        }
        minecraftServer.execute(() -> {
            for (Pair blockPair : parsedSchematicObject.blocks) {
                level.setBlock((BlockPos)blockPair.getFirst(), (BlockState)blockPair.getSecond(), 3);
            }
            minecraftServer.execute(() -> {
                List<ItemStack> pumpkinHeads = SpookyHeads.getAllPumpkinHeads();
                ArrayList<Integer> chestSlotRange = new ArrayList<Integer>(IntStream.rangeClosed(0, 26).boxed().toList());
                ArrayList<Integer> randomAmounts = new ArrayList<Integer>(Arrays.asList(1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2));
                ArrayList<Item> candleItems = new ArrayList<Item>(Arrays.asList(Items.BLACK_CANDLE, Items.ORANGE_CANDLE, Items.RED_CANDLE, Items.WHITE_CANDLE));
                ArrayList<Integer> candleAmounts = new ArrayList<Integer>(Arrays.asList(1, 2, 1, 1, 2, 1, 2, 2, 1, 1, 2));
                for (Pair blockEntityPair : parsedSchematicObject.getBlockEntities(level)) {
                    BlockPos blockPos = (BlockPos)blockEntityPair.getFirst();
                    BlockEntity blockEntity = (BlockEntity)blockEntityPair.getSecond();
                    if (!(blockEntity instanceof ChestBlockEntity)) continue;
                    ChestBlockEntity chestBlockEntity = new ChestBlockEntity(blockPos, blockEntity.getBlockState());
                    DataComponentMap.Builder dataComponentMapBuilder = DataComponentMap.builder();
                    dataComponentMapBuilder.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)"Ritual Storage"));
                    chestBlockEntity.setComponents(dataComponentMapBuilder.build());
                    Collections.shuffle(pumpkinHeads);
                    Collections.shuffle(chestSlotRange);
                    Collections.shuffle(candleItems);
                    Collections.shuffle(candleAmounts);
                    ArrayList<Integer> tempChestSlotRange = new ArrayList<Integer>(chestSlotRange);
                    for (ItemStack pumpkinHead : pumpkinHeads) {
                        pumpkinHead.setCount(((Integer)randomAmounts.get(GlobalVariables.random.nextInt(randomAmounts.size()))).intValue());
                        chestBlockEntity.setItem(((Integer)tempChestSlotRange.getFirst()).intValue(), pumpkinHead);
                        tempChestSlotRange.removeFirst();
                    }
                    if (candleItems.size() > 0) {
                        int i = 0;
                        Iterator iterator = tempChestSlotRange.iterator();
                        while (iterator.hasNext()) {
                            int remainingChestSlot = (Integer)iterator.next();
                            chestBlockEntity.setItem(remainingChestSlot, new ItemStack((ItemLike)candleItems.getFirst(), ((Integer)candleAmounts.get(i)).intValue()));
                            ++i;
                        }
                        candleItems.removeFirst();
                    }
                    level.setBlockEntity((BlockEntity)chestBlockEntity);
                }
                minecraftServer.execute(() -> {
                    LivingEntity ghostRider;
                    LivingEntity ghostKnight;
                    Registry enchantmentRegistry = level.registryAccess().lookupOrThrow(Registries.ENCHANTMENT);
                    int aboveFloorYLevel = pasteNBlocksAboveSurface + 18;
                    BlockPos prisonerPos = centerPos.north(11).east(2).above(aboveFloorYLevel).immutable();
                    Villager prisoner = Prisoner.createPrisoner(level, prisonerPos, player, VillagerProfession.NITWIT, SpookyHeads.getCarvedPumpkin(1), ChatFormatting.GOLD, false);
                    prisoner.getTags().add("pumpkillagersquest.persistent");
                    level.addFreshEntity((Entity)prisoner);
                    BlockPos ghostKnightPos = centerPos.north(3).east(3).above(aboveFloorYLevel).immutable();
                    SkeletonHorse ghostKnightHorse = (SkeletonHorse)EntityType.SKELETON_HORSE.create(level, EntitySpawnReason.STRUCTURE);
                    ghostKnightHorse.setPos((double)ghostKnightPos.getX() + 0.5, (double)ghostKnightPos.getY(), (double)ghostKnightPos.getZ() + 0.5);
                    ghostKnightHorse.equipSaddle(new ItemStack((ItemLike)Items.SADDLE), null);
                    ghostKnightHorse.setTamed(true);
                    if (!isPeaceful) {
                        ghostKnight = (LivingEntity)EntityType.HUSK.create(level, EntitySpawnReason.STRUCTURE);
                        ItemStack swordStack = new ItemStack((ItemLike)Items.GOLDEN_SWORD);
                        swordStack.enchant((Holder)enchantmentRegistry.getOrThrow(Enchantments.SHARPNESS), 1);
                        ghostKnight.setItemSlot(EquipmentSlot.MAINHAND, swordStack);
                        ghostKnight.setItemSlot(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)Items.SHIELD));
                        Husk husk = (Husk)ghostKnight;
                        EntityFunctions.getTargetSelector((Mob)husk).removeAllGoals(goal -> true);
                        EntityFunctions.getTargetSelector((Mob)husk).addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)husk, Player.class, true));
                    } else {
                        ghostKnight = (LivingEntity)EntityType.VILLAGER.create(level, EntitySpawnReason.STRUCTURE);
                    }
                    ghostKnight.setItemSlot(EquipmentSlot.HEAD, SpookyHeads.getGhostKnightHead(1));
                    ghostKnight.setPos((double)ghostKnightPos.getX() + 0.5, (double)ghostKnightPos.getY(), (double)ghostKnightPos.getZ() + 0.5);
                    ghostKnight.setCustomName((Component)Component.literal((String)"The Ghost Knight").withStyle(ChatFormatting.GOLD));
                    level.addFreshEntity((Entity)ghostKnightHorse);
                    level.addFreshEntity((Entity)ghostKnight);
                    BlockPos ghostRiderPos = centerPos.south(3).west(3).above(aboveFloorYLevel).immutable();
                    ZombieHorse ghostRiderHorse = (ZombieHorse)EntityType.ZOMBIE_HORSE.create(level, EntitySpawnReason.STRUCTURE);
                    ghostRiderHorse.setPos((double)ghostRiderPos.getX() + 0.5, (double)ghostRiderPos.getY(), (double)ghostRiderPos.getZ() + 0.5);
                    ghostRiderHorse.equipSaddle(new ItemStack((ItemLike)Items.SADDLE), null);
                    ghostRiderHorse.setTamed(true);
                    if (!isPeaceful) {
                        ghostRider = (LivingEntity)EntityType.STRAY.create(level, EntitySpawnReason.STRUCTURE);
                        ItemStack bowStack = new ItemStack((ItemLike)Items.BOW);
                        bowStack.enchant((Holder)enchantmentRegistry.getOrThrow(Enchantments.INFINITY), 1);
                        ghostRider.setItemSlot(EquipmentSlot.MAINHAND, bowStack);
                    } else {
                        ghostRider = (LivingEntity)EntityType.VILLAGER.create(level, EntitySpawnReason.STRUCTURE);
                    }
                    ghostRider.setItemSlot(EquipmentSlot.HEAD, SpookyHeads.getGhostRiderHead(1));
                    ghostRider.setPos((double)ghostKnightPos.getX() + 0.5, (double)ghostRiderPos.getY(), (double)ghostKnightPos.getZ() + 0.5);
                    ghostRider.setCustomName((Component)Component.literal((String)"The Ghost Rider").withStyle(ChatFormatting.GOLD));
                    level.addFreshEntity((Entity)ghostRiderHorse);
                    level.addFreshEntity((Entity)ghostRider);
                    minecraftServer.execute(() -> {
                        ghostKnight.startRiding((Entity)ghostKnightHorse);
                        ghostRider.startRiding((Entity)ghostRiderHorse);
                        for (int x = -2; x <= 2; ++x) {
                            for (int z = -2; z <= 2; ++z) {
                                LevelChunk levelChunk = level.getChunk(chunkPos.x + x, chunkPos.z + z);
                                levelChunk.postProcessGeneration((ServerLevel)level);
                            }
                        }
                    });
                });
            });
        });
    }

    public static void generateClientRitualVision(Level level, Player player, BlockPos clickPos, ItemStack bookstack) {
        if (!level.isClientSide) {
            return;
        }
        BlockPos centerPos = clickPos.above().immutable();
        Block centerBlock = Blocks.TNT;
        Block ritualBlock = Blocks.REDSTONE_WIRE;
        if (!bookstack.getDisplayName().getString().contains("Quest")) {
            centerBlock = Blocks.PUMPKIN;
            ritualBlock = Blocks.CANDLE;
        }
        ClientRenderEvent.setTemporaryRitualRender(centerPos, centerBlock, ritualBlock);
    }
}

