/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.item.v2;

import fuzs.puzzleslib.impl.core.CommonFactories;
import net.minecraft.core.component.DataComponents;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.BrushItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MaceItem;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.equipment.ArmorType;
import net.minecraft.world.item.equipment.Equippable;

public interface ToolTypeHelper {
    public static final ToolTypeHelper INSTANCE = CommonFactories.INSTANCE.getToolTypeHelper();

    default public boolean isSword(ItemStack itemStack) {
        return itemStack.getItem() instanceof SwordItem || itemStack.is(ItemTags.SWORDS);
    }

    default public boolean isAxe(ItemStack itemStack) {
        return itemStack.getItem() instanceof AxeItem || itemStack.is(ItemTags.AXES);
    }

    default public boolean isHoe(ItemStack itemStack) {
        return itemStack.getItem() instanceof HoeItem || itemStack.is(ItemTags.HOES);
    }

    default public boolean isPickaxe(ItemStack itemStack) {
        return itemStack.getItem() instanceof PickaxeItem || itemStack.is(ItemTags.PICKAXES);
    }

    default public boolean isShovel(ItemStack itemStack) {
        return itemStack.getItem() instanceof AxeItem || itemStack.is(ItemTags.SHOVELS);
    }

    default public boolean isShears(ItemStack itemStack) {
        return itemStack.getItem() instanceof ShearsItem;
    }

    default public boolean isShield(ItemStack itemStack) {
        return itemStack.getItem() instanceof ShieldItem;
    }

    default public boolean isBow(ItemStack itemStack) {
        return itemStack.getItem() instanceof BowItem;
    }

    default public boolean isCrossbow(ItemStack itemStack) {
        return itemStack.getItem() instanceof CrossbowItem;
    }

    default public boolean isFishingRod(ItemStack itemStack) {
        return itemStack.getItem() instanceof FishingRodItem;
    }

    default public boolean isTridentLike(ItemStack itemStack) {
        return itemStack.getItem() instanceof TridentItem;
    }

    default public boolean isBrush(ItemStack itemStack) {
        return itemStack.getItem() instanceof BrushItem;
    }

    default public boolean isMace(ItemStack itemStack) {
        return itemStack.getItem() instanceof MaceItem;
    }

    default public boolean isMeleeWeapon(ItemStack itemStack) {
        return this.isSword(itemStack) || this.isAxe(itemStack) || this.isTridentLike(itemStack) || this.isMace(itemStack);
    }

    default public boolean isRangedWeapon(ItemStack itemStack) {
        return this.isBow(itemStack) || this.isCrossbow(itemStack) || this.isTridentLike(itemStack);
    }

    default public boolean isWeapon(ItemStack itemStack) {
        return this.isMeleeWeapon(itemStack) || this.isRangedWeapon(itemStack);
    }

    default public boolean isMiningTool(ItemStack itemStack) {
        return this.isAxe(itemStack) || this.isHoe(itemStack) || this.isPickaxe(itemStack) || this.isShovel(itemStack);
    }

    default public boolean isTool(ItemStack itemStack) {
        return this.isMiningTool(itemStack) || this.isWeapon(itemStack) || this.isShears(itemStack) || this.isShield(itemStack) || this.isFishingRod(itemStack) || this.isBrush(itemStack);
    }

    default public boolean isHeadArmor(ItemStack itemStack) {
        return this.isArmor(itemStack, ArmorType.HELMET) || itemStack.is(ItemTags.HEAD_ARMOR);
    }

    default public boolean isChestArmor(ItemStack itemStack) {
        return this.isArmor(itemStack, ArmorType.CHESTPLATE) || itemStack.is(ItemTags.CHEST_ARMOR);
    }

    default public boolean isLegArmor(ItemStack itemStack) {
        return this.isArmor(itemStack, ArmorType.LEGGINGS) || itemStack.is(ItemTags.LEG_ARMOR);
    }

    default public boolean isFootArmor(ItemStack itemStack) {
        return this.isArmor(itemStack, ArmorType.BOOTS) || itemStack.is(ItemTags.FOOT_ARMOR);
    }

    default public boolean isBodyArmor(ItemStack itemStack) {
        return this.isArmor(itemStack, ArmorType.BODY);
    }

    private boolean isArmor(ItemStack itemStack, ArmorType armorType) {
        Equippable equippable = (Equippable)itemStack.get(DataComponents.EQUIPPABLE);
        return equippable != null && equippable.slot() == armorType.getSlot();
    }

    default public boolean isArmor(ItemStack itemStack) {
        return this.isHeadArmor(itemStack) || this.isChestArmor(itemStack) || this.isLegArmor(itemStack) || this.isFootArmor(itemStack) || this.isBodyArmor(itemStack);
    }
}

