/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.item;

import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;

public final class CreativeModeTabHelper {
    static final Collection<Item> POTION_ITEMS = ImmutableSet.of((Object)Items.POTION, (Object)Items.SPLASH_POTION, (Object)Items.LINGERING_POTION, (Object)Items.TIPPED_ARROW);

    private CreativeModeTabHelper() {
    }

    public static Component getTitle(ResourceLocation resourceLocation) {
        String translationKey = "itemGroup.%s.%s".formatted(resourceLocation.getNamespace(), resourceLocation.getPath());
        return Component.translatable((String)translationKey);
    }

    public static CreativeModeTab.DisplayItemsGenerator getDisplayItems(String modId) {
        return CreativeModeTabHelper.getDisplayItems(modId, (Predicate<ItemStack>)Predicates.alwaysTrue());
    }

    public static CreativeModeTab.DisplayItemsGenerator getDisplayItems(String modId, Predicate<ItemStack> filter) {
        return (itemDisplayParameters, output) -> {
            Consumer<ItemStack> itemStacks = itemStack -> {
                if (filter.test((ItemStack)itemStack)) {
                    output.accept(itemStack);
                }
            };
            CreativeModeTabHelper.appendAllItems(modId, itemDisplayParameters.holders(), itemStacks);
            CreativeModeTabHelper.appendAllEnchantments(modId, itemDisplayParameters.holders(), itemStacks);
            CreativeModeTabHelper.appendAllPotions(modId, itemDisplayParameters.holders(), itemStacks);
        };
    }

    public static void appendAllItems(String modId, HolderLookup.Provider registries, Consumer<ItemStack> itemStacks) {
        CreativeModeTabHelper.getHoldersFromNamespace(Registries.ITEM, registries, modId).map(ItemStack::new).forEach(itemStacks);
    }

    public static void appendAllEnchantments(String modId, HolderLookup.Provider registries, Consumer<ItemStack> itemStacks) {
        CreativeModeTabHelper.getHoldersFromNamespace(Registries.ENCHANTMENT, registries, modId).map(holder -> new EnchantmentInstance((Holder)holder, ((Enchantment)holder.value()).getMaxLevel())).map(EnchantmentHelper::createBook).forEach(itemStacks);
    }

    public static void appendAllPotions(String modId, HolderLookup.Provider registries, Consumer<ItemStack> itemStacks) {
        List<Holder.Reference> potions = CreativeModeTabHelper.getHoldersFromNamespace(Registries.POTION, registries, modId).filter(holder -> !((Potion)holder.value()).getEffects().isEmpty()).sorted(Comparator.comparing(holder -> (MobEffectInstance)((Potion)holder.value()).getEffects().getFirst())).toList();
        for (Item item : POTION_ITEMS) {
            for (Holder.Reference potion : potions) {
                itemStacks.accept(PotionContents.createItemStack((Item)item, (Holder)potion));
            }
        }
    }

    public static <T> Stream<Holder.Reference<T>> getHoldersFromNamespace(ResourceKey<? extends Registry<? extends T>> registryKey, HolderLookup.Provider registries, String modId) {
        return registries.lookup(registryKey).stream().flatMap(HolderLookup::listElements).filter(holder -> holder.key().location().getNamespace().equals(modId));
    }
}

