/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.neoforge.api.client.data.v2;

import fuzs.puzzleslib.api.core.v1.utility.ResourceLocationHelper;
import fuzs.puzzleslib.api.data.v2.core.DataProviderContext;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.neoforged.neoforge.common.data.SoundDefinition;
import net.neoforged.neoforge.common.data.SoundDefinitionsProvider;

public abstract class AbstractSoundProvider
extends SoundDefinitionsProvider {
    protected final String modId;

    public AbstractSoundProvider(DataProviderContext context) {
        this(context.getModId(), context.getPackOutput());
    }

    public AbstractSoundProvider(String modId, PackOutput packOutput) {
        super(packOutput, modId);
        this.modId = modId;
    }

    protected static SoundDefinition.Sound sound(SoundEvent soundEvent) {
        return AbstractSoundProvider.sound((ResourceLocation)soundEvent.location(), (SoundDefinition.SoundType)SoundDefinition.SoundType.EVENT);
    }

    public final void registerSounds() {
        this.addSounds();
    }

    public abstract void addSounds();

    protected void add(SoundEvent soundEvent, String ... sounds) {
        SoundDefinition definition = AbstractSoundProvider.definition();
        for (String sound : sounds) {
            definition.with(AbstractSoundProvider.sound((String)sound));
        }
        this.add(soundEvent, definition);
    }

    protected void add(SoundEvent soundEvent, ResourceLocation ... sounds) {
        SoundDefinition definition = AbstractSoundProvider.definition();
        for (ResourceLocation sound : sounds) {
            definition.with(AbstractSoundProvider.sound((ResourceLocation)sound));
        }
        this.add(soundEvent, definition);
    }

    protected void add(SoundEvent soundEvent, SoundEvent ... soundEvents) {
        SoundDefinition definition = AbstractSoundProvider.definition();
        for (SoundEvent vanillaSoundEvent : soundEvents) {
            definition.with(AbstractSoundProvider.sound(vanillaSoundEvent));
        }
        this.add(soundEvent, definition);
    }

    protected void add(SoundEvent soundEvent, SoundDefinition.Sound ... sounds) {
        this.add(soundEvent.location(), AbstractSoundProvider.definition().with(sounds));
    }

    protected void add(ResourceLocation soundEvent, SoundDefinition definition) {
        super.add(soundEvent, definition.subtitle("subtitles." + soundEvent.getPath()));
    }

    protected ResourceLocation id(String path) {
        return ResourceLocationHelper.fromNamespaceAndPath(this.modId, path);
    }

    protected ResourceLocation vanilla(String path) {
        return ResourceLocationHelper.withDefaultNamespace(path);
    }

    public String getName() {
        return "Sounds";
    }
}

