/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.neoforge.impl.capability;

import fuzs.puzzleslib.api.capability.v3.CapabilityController;
import fuzs.puzzleslib.api.capability.v3.data.BlockEntityCapabilityKey;
import fuzs.puzzleslib.api.capability.v3.data.CapabilityComponent;
import fuzs.puzzleslib.api.capability.v3.data.CapabilityKey;
import fuzs.puzzleslib.api.capability.v3.data.EntityCapabilityKey;
import fuzs.puzzleslib.api.capability.v3.data.LevelCapabilityKey;
import fuzs.puzzleslib.api.capability.v3.data.LevelChunkCapabilityKey;
import fuzs.puzzleslib.impl.capability.GlobalCapabilityRegister;
import fuzs.puzzleslib.neoforge.api.core.v1.NeoForgeModContainerHelper;
import fuzs.puzzleslib.neoforge.impl.capability.data.NeoForgeBlockEntityCapabilityKey;
import fuzs.puzzleslib.neoforge.impl.capability.data.NeoForgeCapabilityKey;
import fuzs.puzzleslib.neoforge.impl.capability.data.NeoForgeEntityCapabilityKey;
import fuzs.puzzleslib.neoforge.impl.capability.data.NeoForgeLevelCapabilityKey;
import fuzs.puzzleslib.neoforge.impl.capability.data.NeoForgeLevelChunkCapabilityKey;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.attachment.IAttachmentSerializer;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

public final class NeoForgeCapabilityController
implements CapabilityController {
    private final DeferredRegister<AttachmentType<?>> registrar;

    public NeoForgeCapabilityController(String modId) {
        this.registrar = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.ATTACHMENT_TYPES, (String)modId);
        NeoForgeModContainerHelper.getOptionalModEventBus(modId).ifPresent(arg_0 -> this.registrar.register(arg_0));
    }

    @Override
    public <T extends Entity, C extends CapabilityComponent<T>> EntityCapabilityKey.Mutable<T, C> registerEntityCapability(String identifier, Class<C> capabilityType, Supplier<C> capabilityFactory, Class<T> entityType) {
        return (EntityCapabilityKey.Mutable)this.registerCapability(Entity.class, identifier, capabilityFactory, entityType::isInstance, NeoForgeEntityCapabilityKey::new);
    }

    @Override
    public <T extends BlockEntity, C extends CapabilityComponent<T>> BlockEntityCapabilityKey<T, C> registerBlockEntityCapability(String identifier, Class<C> capabilityType, Supplier<C> capabilityFactory, Class<T> blockEntityType) {
        return (BlockEntityCapabilityKey)this.registerCapability(BlockEntity.class, identifier, capabilityFactory, blockEntityType::isInstance, NeoForgeBlockEntityCapabilityKey::new);
    }

    @Override
    public <C extends CapabilityComponent<LevelChunk>> LevelChunkCapabilityKey<C> registerLevelChunkCapability(String identifier, Class<C> capabilityType, Supplier<C> capabilityFactory) {
        return (LevelChunkCapabilityKey)this.registerCapability(LevelChunk.class, identifier, capabilityFactory, NeoForgeLevelChunkCapabilityKey::new);
    }

    @Override
    public <C extends CapabilityComponent<Level>> LevelCapabilityKey<C> registerLevelCapability(String identifier, Class<C> capabilityType, Supplier<C> capabilityFactory) {
        return (LevelCapabilityKey)this.registerCapability(Level.class, identifier, capabilityFactory, NeoForgeLevelCapabilityKey::new);
    }

    private <T, C extends CapabilityComponent<T>, K extends CapabilityKey<T, C>> K registerCapability(Class<? extends IAttachmentHolder> holderType, String identifier, Supplier<C> capabilityFactory, NeoForgeCapabilityKey.Factory<T, C, K> capabilityKeyFactory) {
        return this.registerCapability(holderType, identifier, capabilityFactory, holderType::isInstance, capabilityKeyFactory);
    }

    private <T, C extends CapabilityComponent<T>, K extends CapabilityKey<T, C>> K registerCapability(Class<? extends IAttachmentHolder> holderType, String identifier, final Supplier<C> capabilityFactory, Predicate<Object> filter, NeoForgeCapabilityKey.Factory<T, C, K> capabilityKeyFactory) {
        GlobalCapabilityRegister.testHolderType(holderType);
        final Object[] capabilityKey = new Object[1];
        DeferredHolder holder = this.registrar.register(identifier, () -> AttachmentType.builder(arg_0 -> NeoForgeCapabilityController.lambda$registerCapability$0((Supplier)capabilityFactory, capabilityKey, arg_0)).serialize(new IAttachmentSerializer<Tag, C>(this){

            public C read(IAttachmentHolder attachmentHolder, Tag tag, HolderLookup.Provider registries) {
                CapabilityComponent capabilityComponent = (CapabilityComponent)capabilityFactory.get();
                Objects.requireNonNull(capabilityComponent, "capability component is null");
                capabilityComponent.initialize((CapabilityKey)capabilityKey[0], attachmentHolder);
                capabilityComponent.read((CompoundTag)tag, registries);
                return capabilityComponent;
            }

            public Tag write(C object, HolderLookup.Provider registries) {
                return object.toCompoundTag(registries);
            }
        }).build());
        capabilityKey[0] = capabilityKeyFactory.apply(holder, filter);
        return (K)((CapabilityKey)capabilityKey[0]);
    }

    private static /* synthetic */ CapabilityComponent lambda$registerCapability$0(Supplier capabilityFactory, Object[] capabilityKey, IAttachmentHolder attachmentHolder) {
        CapabilityComponent capabilityComponent = (CapabilityComponent)capabilityFactory.get();
        Objects.requireNonNull(capabilityComponent, "capability component is null");
        capabilityComponent.initialize((CapabilityKey)capabilityKey[0], attachmentHolder);
        return capabilityComponent;
    }
}

