/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.neoforge.impl.client.core.context;

import com.google.common.base.Suppliers;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import fuzs.puzzleslib.api.client.core.v1.context.BlockStateResolverContext;
import fuzs.puzzleslib.api.client.util.v1.ModelLoadingHelper;
import fuzs.puzzleslib.impl.PuzzlesLib;
import fuzs.puzzleslib.impl.PuzzlesLibMod;
import fuzs.puzzleslib.impl.client.core.context.ResourceLoaderContextImpl;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.model.UnbakedBlockStateModel;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelDebugName;
import net.minecraft.client.resources.model.ModelDiscovery;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.ResolvableModel;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.event.ModelEvent;

public final class BlockStateResolverContextNeoForgeImpl
implements BlockStateResolverContext {
    private final ResourceManager resourceManager = Minecraft.getInstance().getResourceManager();
    private final Function<Material, TextureAtlasSprite> textureGetter;
    private final UnbakedModel missingModel;
    private final Supplier<TextureAtlasSprite> missingSprite;
    private final Map<ResourceLocation, UnbakedModel> unbakedPlainModels;
    private final BiConsumer<ModelResourceLocation, BakedModel> blockStateModelOutput;

    public BlockStateResolverContextNeoForgeImpl(ModelEvent.ModifyBakingResult evt) {
        this.textureGetter = evt.getTextureGetter();
        this.missingModel = evt.getModelBakery().missingModel;
        this.missingSprite = Suppliers.memoize(() -> {
            Material material = new Material(TextureAtlas.LOCATION_BLOCKS, MissingTextureAtlasSprite.getLocation());
            TextureAtlasSprite textureAtlasSprite = (TextureAtlasSprite)evt.getTextureGetter().apply(material);
            Objects.requireNonNull(textureAtlasSprite, "missing sprite is null");
            return textureAtlasSprite;
        });
        this.unbakedPlainModels = new HashMap<ResourceLocation, UnbakedModel>(evt.getModelBakery().unbakedPlainModels);
        this.blockStateModelOutput = evt.getBakingResult().blockStateModels()::put;
    }

    @Override
    public void registerBlockStateResolver(Block block, Consumer<BiConsumer<BlockState, UnbakedBlockStateModel>> blockStateConsumer) {
        ModelDiscovery modelDiscovery = new ModelDiscovery(Collections.emptyMap(), this.missingModel){

            protected UnbakedModel loadBlockModel(ResourceLocation modelLocation) {
                return BlockStateResolverContextNeoForgeImpl.this.getBlockModel(modelLocation);
            }
        };
        HashMap<ModelResourceLocation, UnbakedBlockStateModel> unbakedBlockStateModels = new HashMap<ModelResourceLocation, UnbakedBlockStateModel>();
        blockStateConsumer.accept((blockState, unbakedBlockStateModel) -> {
            modelDiscovery.addRoot((ResolvableModel)unbakedBlockStateModel);
            unbakedBlockStateModels.put(BlockModelShaper.stateToModelLocation((BlockState)blockState), (UnbakedBlockStateModel)unbakedBlockStateModel);
        });
        modelDiscovery.discoverDependencies();
        this.loadModels(unbakedBlockStateModels).blockStateModels().forEach(this.blockStateModelOutput);
    }

    UnbakedModel getBlockModel(ResourceLocation resourceLocation) {
        return this.unbakedPlainModels.computeIfAbsent(resourceLocation, resourceLocationX -> ModelLoadingHelper.loadBlockModel(this.resourceManager, resourceLocationX, this.missingModel));
    }

    ModelBakery.BakingResult loadModels(Map<ModelResourceLocation, UnbakedBlockStateModel> unbakedBlockStateModels) {
        ModelBakery modelBakery = new ModelBakery(EntityModelSet.EMPTY, unbakedBlockStateModels, Collections.emptyMap(), this.unbakedPlainModels, this.missingModel, Collections.emptyMap());
        return BlockStateResolverContextNeoForgeImpl.loadModels(Profiler.get(), this.textureGetter, modelBakery, this.missingSprite);
    }

    @Override
    public <T> void registerBlockStateResolver(Block block, Function<BlockStateResolverContext.ResourceLoaderContext, CompletableFuture<T>> resourceLoader, BiConsumer<T, BiConsumer<BlockState, UnbakedBlockStateModel>> blockStateConsumer) {
        this.registerBlockStateResolver(block, consumer -> blockStateConsumer.accept(((CompletableFuture)resourceLoader.apply(new ResourceLoaderContextImpl(this.resourceManager, (Executor)Util.backgroundExecutor(), this.unbakedPlainModels))).join(), (BiConsumer<BlockState, UnbakedBlockStateModel>)consumer));
    }

    static ModelBakery.BakingResult loadModels(ProfilerFiller profiler, final Function<Material, TextureAtlasSprite> textureGetter, ModelBakery modelBakery, Supplier<TextureAtlasSprite> missingSprite) {
        profiler.push(PuzzlesLibMod.id("baking").toString());
        HashMultimap multimap = HashMultimap.create();
        HashMultimap multimap1 = HashMultimap.create();
        ModelBakery.BakingResult bakingResult = modelBakery.bakeModels(new ModelBakery.TextureGetter(){
            final /* synthetic */ Multimap val$multimap;
            final /* synthetic */ Supplier val$missingSprite;
            final /* synthetic */ Multimap val$multimap1;
            {
                this.val$multimap = multimap;
                this.val$missingSprite = supplier;
                this.val$multimap1 = multimap2;
            }

            public TextureAtlasSprite get(ModelDebugName name, Material material) {
                TextureAtlasSprite textureAtlasSprite = (TextureAtlasSprite)textureGetter.apply(material);
                if (textureAtlasSprite != null) {
                    return textureAtlasSprite;
                }
                this.val$multimap.put((Object)((String)name.get()), (Object)material);
                return (TextureAtlasSprite)this.val$missingSprite.get();
            }

            public TextureAtlasSprite reportMissingReference(ModelDebugName name, String reference) {
                this.val$multimap1.put((Object)((String)name.get()), (Object)reference);
                return (TextureAtlasSprite)this.val$missingSprite.get();
            }
        });
        multimap.asMap().forEach((string, collection) -> PuzzlesLib.LOGGER.warn("Missing textures in model {}:\n{}", string, (Object)collection.stream().sorted(Material.COMPARATOR).map(arg -> "    " + String.valueOf(arg.atlasLocation()) + ":" + String.valueOf(arg.texture())).collect(Collectors.joining("\n"))));
        multimap1.asMap().forEach((string, collection) -> PuzzlesLib.LOGGER.warn("Missing texture references in model {}:\n{}", string, (Object)collection.stream().sorted().map(stringx -> "    " + stringx).collect(Collectors.joining("\n"))));
        profiler.pop();
        return bakingResult;
    }
}

