/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.neoforge.impl.core;

import fuzs.puzzleslib.api.core.v1.CommonAbstractions;
import fuzs.puzzleslib.api.init.v3.registry.LookupHelper;
import fuzs.puzzleslib.neoforge.api.event.v1.entity.living.ComputeEnchantedLootBonusEvent;
import java.util.Collections;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackCompatibility;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerExplosion;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.entity.PartEntity;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.Nullable;

public final class NeoForgeAbstractions
implements CommonAbstractions {
    @Override
    public MinecraftServer getMinecraftServer() {
        return ServerLifecycleHooks.getCurrentServer();
    }

    @Override
    public boolean hasChannel(ServerPlayer serverPlayer, CustomPacketPayload.Type<?> type) {
        return serverPlayer.connection != null && serverPlayer.connection.hasChannel(type);
    }

    @Override
    public void openMenu(ServerPlayer player, MenuProvider menuProvider, BiConsumer<ServerPlayer, RegistryFriendlyByteBuf> dataWriter) {
        player.openMenu(menuProvider, buf -> dataWriter.accept(player, (RegistryFriendlyByteBuf)buf));
    }

    @Override
    public Entity getPartEntityParent(Entity entity) {
        Entity entity2;
        if (entity instanceof PartEntity) {
            PartEntity partEntity = (PartEntity)entity;
            entity2 = partEntity.getParent();
        } else {
            entity2 = entity;
        }
        return entity2;
    }

    @Override
    public boolean isBossMob(EntityType<?> type) {
        return type.is(Tags.EntityTypes.BOSSES);
    }

    @Override
    public float getEnchantPowerBonus(BlockState state, Level level, BlockPos pos) {
        return state.getEnchantPowerBonus((LevelReader)level, pos);
    }

    @Override
    public boolean canEquip(ItemStack stack, EquipmentSlot slot, LivingEntity entity) {
        return stack.canEquip(slot, entity);
    }

    @Override
    public int getMobLootingLevel(Entity target, @Nullable Entity attacker, @Nullable DamageSource damageSource) {
        int enchantmentLevel = CommonAbstractions.super.getMobLootingLevel(target, attacker, damageSource);
        if (!(target instanceof LivingEntity)) {
            return enchantmentLevel;
        }
        LivingEntity livingEntity = (LivingEntity)target;
        Holder<Enchantment> enchantment = LookupHelper.lookupEnchantment(target, (ResourceKey<Enchantment>)Enchantments.LOOTING);
        return ComputeEnchantedLootBonusEvent.onComputeEnchantedLootBonus(enchantment, enchantmentLevel, livingEntity, damageSource);
    }

    @Override
    public boolean getMobGriefingRule(ServerLevel serverLevel, @Nullable Entity entity) {
        return EventHooks.canEntityGrief((ServerLevel)serverLevel, (Entity)entity);
    }

    @Override
    public void onPlayerDestroyItem(Player player, ItemStack originalItemStack, @Nullable InteractionHand interactionHand) {
        EventHooks.onPlayerDestroyItem((Player)player, (ItemStack)originalItemStack, (InteractionHand)interactionHand);
    }

    @Override
    @Nullable
    public EntitySpawnReason getMobSpawnType(Mob mob) {
        return mob.getSpawnType();
    }

    @Override
    public Pack.Metadata createPackInfo(ResourceLocation id, Component description, PackCompatibility packCompatibility, FeatureFlagSet features, boolean hidden) {
        return new Pack.Metadata(description, packCompatibility, features, Collections.emptyList(), hidden);
    }

    @Override
    public boolean canApplyAtEnchantingTable(Holder<Enchantment> enchantment, ItemStack itemStack) {
        return itemStack.isPrimaryItemFor(enchantment);
    }

    @Override
    public boolean isBookEnchantable(ItemStack inputStack, ItemStack bookStack) {
        return inputStack.isBookEnchantable(bookStack);
    }

    @Override
    public boolean onExplosionStart(ServerLevel serverLevel, ServerExplosion explosion) {
        return EventHooks.onExplosionStart((Level)serverLevel, (ServerExplosion)explosion);
    }
}

