/*
 * Decompiled with CFR 0.152.
 */
package net.xstopho.resource_nether_ores.datagen;

import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.xstopho.resource_nether_ores.registries.BlockRegistry;
import net.xstopho.resourcelibrary.registration.RegistryObject;

public class ModelsProvider
extends BlockStateProvider {
    public ModelsProvider(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "resource_nether_ores", exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.createNetherrackOreBlock(BlockRegistry.NETHER_COAL_ORE, "coal_ore");
        this.createNetherrackOreBlock(BlockRegistry.NETHER_COPPER_ORE, "copper_ore");
        this.createNetherrackOreBlock(BlockRegistry.NETHER_IRON_ORE, "iron_ore");
        this.createNetherrackOreBlock(BlockRegistry.NETHER_DIAMOND_ORE, "diamond_ore");
        this.createNetherrackOreBlock(BlockRegistry.NETHER_EMERALD_ORE, "emerald_ore");
        this.createNetherrackOreBlock(BlockRegistry.NETHER_LAPIS_ORE, "lapis_ore");
        this.createNetherrackOreBlock(BlockRegistry.NETHER_REDSTONE_ORE, "redstone_ore");
        this.createBasaltkOreBlock(BlockRegistry.BASALT_COAL_ORE, "coal_ore");
        this.createBasaltkOreBlock(BlockRegistry.BASALT_COPPER_ORE, "copper_ore");
        this.createBasaltkOreBlock(BlockRegistry.BASALT_IRON_ORE, "iron_ore");
        this.createBasaltkOreBlock(BlockRegistry.BASALT_DIAMOND_ORE, "diamond_ore");
        this.createBasaltkOreBlock(BlockRegistry.BASALT_EMERALD_ORE, "emerald_ore");
        this.createBasaltkOreBlock(BlockRegistry.BASALT_LAPIS_ORE, "lapis_ore");
        this.createBasaltkOreBlock(BlockRegistry.BASALT_REDSTONE_ORE, "redstone_ore");
    }

    void createNetherrackOreBlock(RegistryObject<Block> block, String textureKey) {
        this.simpleBlockWithItem((Block)block.get(), this.createLayeredNetherOreBlock((String)textureKey).model);
    }

    void createBasaltkOreBlock(RegistryObject<Block> block, String textureKey) {
        this.simpleBlockWithItem((Block)block.get(), this.createLayeredBasaltOreBlock((String)textureKey).model);
    }

    private ConfiguredModel createLayeredNetherOreBlock(String textureKey) {
        return new ConfiguredModel((ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("nether_" + textureKey, this.location("block/simple_cube"))).texture("all", ResourceLocation.withDefaultNamespace((String)"block/netherrack"))).texture("layer0", this.location("block/" + textureKey)));
    }

    private ConfiguredModel createLayeredBasaltOreBlock(String textureKey) {
        return new ConfiguredModel((ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("basalt_" + textureKey, this.location("block/cube_column"))).texture("end", ResourceLocation.withDefaultNamespace((String)"block/basalt_top"))).texture("side", ResourceLocation.withDefaultNamespace((String)"block/basalt_side"))).texture("layer0", this.location("block/" + textureKey)));
    }

    private ResourceLocation location(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)"resource_nether_ores", (String)path);
    }
}

