/*
 * Decompiled with CFR 0.152.
 */
package net.xstopho.resource_nether_ores.registries;

import java.util.function.Function;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DropExperienceBlock;
import net.minecraft.world.level.block.RedStoneOreBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.xstopho.resourcelibrary.registration.RegistryObject;
import net.xstopho.resourcelibrary.registration.RegistryProvider;

public class BlockRegistry {
    public static final RegistryProvider<Block> BLOCKS = RegistryProvider.get((String)"resource_nether_ores", (Registry)BuiltInRegistries.BLOCK);
    private static final RegistryProvider<Item> ITEMS = RegistryProvider.get((String)"resource_nether_ores", (Registry)BuiltInRegistries.ITEM);
    public static final RegistryObject<Block> NETHER_COAL_ORE = BlockRegistry.register("nether_coal_ore", properties -> new DropExperienceBlock((IntProvider)ConstantInt.of((int)0), properties), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.COAL_ORE));
    public static final RegistryObject<Block> NETHER_COPPER_ORE = BlockRegistry.register("nether_copper_ore", properties -> new DropExperienceBlock((IntProvider)ConstantInt.of((int)0), properties), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.COPPER_ORE));
    public static final RegistryObject<Block> NETHER_IRON_ORE = BlockRegistry.register("nether_iron_ore", properties -> new DropExperienceBlock((IntProvider)ConstantInt.of((int)0), properties), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_ORE));
    public static final RegistryObject<Block> NETHER_DIAMOND_ORE = BlockRegistry.register("nether_diamond_ore", properties -> new DropExperienceBlock((IntProvider)UniformInt.of((int)1, (int)7), properties), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DIAMOND_ORE));
    public static final RegistryObject<Block> NETHER_EMERALD_ORE = BlockRegistry.register("nether_emerald_ore", properties -> new DropExperienceBlock((IntProvider)UniformInt.of((int)1, (int)7), properties), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.EMERALD_ORE));
    public static final RegistryObject<Block> NETHER_LAPIS_ORE = BlockRegistry.register("nether_lapis_ore", properties -> new DropExperienceBlock((IntProvider)UniformInt.of((int)1, (int)5), properties), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.LAPIS_ORE));
    public static final RegistryObject<Block> NETHER_REDSTONE_ORE = BlockRegistry.register("nether_redstone_ore", RedStoneOreBlock::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.REDSTONE_ORE));
    public static final RegistryObject<Block> BASALT_COAL_ORE = BlockRegistry.register("basalt_coal_ore", properties -> new DropExperienceBlock((IntProvider)ConstantInt.of((int)0), properties), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DEEPSLATE_COAL_ORE));
    public static final RegistryObject<Block> BASALT_COPPER_ORE = BlockRegistry.register("basalt_copper_ore", properties -> new DropExperienceBlock((IntProvider)ConstantInt.of((int)0), properties), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DEEPSLATE_COPPER_ORE));
    public static final RegistryObject<Block> BASALT_IRON_ORE = BlockRegistry.register("basalt_iron_ore", properties -> new DropExperienceBlock((IntProvider)ConstantInt.of((int)0), properties), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DEEPSLATE_IRON_ORE));
    public static final RegistryObject<Block> BASALT_DIAMOND_ORE = BlockRegistry.register("basalt_diamond_ore", properties -> new DropExperienceBlock((IntProvider)UniformInt.of((int)1, (int)7), properties), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DEEPSLATE_DIAMOND_ORE));
    public static final RegistryObject<Block> BASALT_EMERALD_ORE = BlockRegistry.register("basalt_emerald_ore", properties -> new DropExperienceBlock((IntProvider)UniformInt.of((int)1, (int)7), properties), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DEEPSLATE_EMERALD_ORE));
    public static final RegistryObject<Block> BASALT_LAPIS_ORE = BlockRegistry.register("basalt_lapis_ore", properties -> new DropExperienceBlock((IntProvider)UniformInt.of((int)1, (int)5), properties), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DEEPSLATE_LAPIS_ORE));
    public static final RegistryObject<Block> BASALT_REDSTONE_ORE = BlockRegistry.register("basalt_redstone_ore", RedStoneOreBlock::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DEEPSLATE_REDSTONE_ORE));

    private static RegistryObject<Block> register(String id, Function<BlockBehaviour.Properties, Block> function, BlockBehaviour.Properties blockBehavior) {
        RegistryObject toReturn = BLOCKS.register(id, () -> (Block)function.apply(blockBehavior.setId(BlockRegistry.createBlockKey(id))));
        BlockRegistry.register(id, properties -> new BlockItem((Block)toReturn.get(), properties.useBlockDescriptionPrefix()));
        return toReturn;
    }

    private static void register(String id, Function<Item.Properties, Item> function) {
        ITEMS.register(id, () -> (Item)function.apply(new Item.Properties().setId(BlockRegistry.createItemKey(id))));
    }

    private static ResourceKey<Block> createBlockKey(String id) {
        return ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"resource_nether_ores", (String)id));
    }

    private static ResourceKey<Item> createItemKey(String id) {
        return ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"resource_nether_ores", (String)id));
    }

    public static void init() {
    }
}

