/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.rockets.integration.jei;

import de.maxhenkel.rockets.item.ItemReusableRocket;
import de.maxhenkel.rockets.recipe.RefuelRecipe;
import java.util.Arrays;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.ingredient.ICraftingGridHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.category.extensions.vanilla.crafting.ICraftingCategoryExtension;
import net.minecraft.core.Holder;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;

public class RefuelExtension<T extends RefuelRecipe>
implements ICraftingCategoryExtension<T> {
    public void setRecipe(RecipeHolder<T> recipeHolder, IRecipeLayoutBuilder builder, ICraftingGridHelper craftingGridHelper, IFocusGroup focuses) {
        RefuelRecipe recipe = (RefuelRecipe)recipeHolder.value();
        ItemStack in = recipe.getRocket().copy();
        Item item = in.getItem();
        if (!(item instanceof ItemReusableRocket)) {
            return;
        }
        ItemReusableRocket rocket = (ItemReusableRocket)item;
        rocket.setUsesLeft(in, rocket.getMaxUses() / 2);
        ItemStack out1 = in.copy();
        rocket.setUsesLeft(out1, Math.min(rocket.getUsesLeft(in) + 8, rocket.getMaxUses()));
        List<ItemStack> fuels = recipe.getFuel().getValues().stream().map(Holder::value).map(ItemStack::new).toList();
        craftingGridHelper.createAndSetInputs(builder, (IIngredientType)VanillaTypes.ITEM_STACK, Arrays.asList(fuels, fuels, fuels, fuels, List.of(in), fuels, fuels, fuels, fuels), 0, 0);
        craftingGridHelper.createAndSetOutputs(builder, (IIngredientType)VanillaTypes.ITEM_STACK, List.of(out1));
    }
}

