/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.rockets.item;

import de.maxhenkel.rockets.Main;
import de.maxhenkel.rockets.item.RocketData;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.Fireworks;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class ItemReusableRocket
extends Item {
    private final Supplier<Integer> maxDuration;
    private final Supplier<Integer> maxUses;

    public ItemReusableRocket(Item.Properties properties, Supplier<Integer> maxUses, Supplier<Integer> maxDuration) {
        super(properties.stacksTo(1));
        this.maxDuration = maxDuration;
        this.maxUses = maxUses;
    }

    public RocketData createDefaultRocketData() {
        return new RocketData(this.maxDuration.get().byteValue(), this.maxUses.get());
    }

    public RocketData getRocketData(ItemStack stack) {
        if (!(stack.getItem() instanceof ItemReusableRocket)) {
            throw new IllegalArgumentException("Not a reusable rocket");
        }
        RocketData rocketData = (RocketData)stack.get(Main.ROCKET_DATA_COMPONENT);
        if (rocketData == null) {
            rocketData = this.createDefaultRocketData();
            stack.set(Main.ROCKET_DATA_COMPONENT, (Object)rocketData);
        }
        return rocketData;
    }

    public InteractionResult use(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (player.isShiftKeyDown()) {
            byte duration = this.getFlightDuration(stack);
            if ((duration = (byte)(duration + 1)) > this.maxDuration.get()) {
                duration = 1;
            }
            this.setFlightDuration(stack, duration);
            player.displayClientMessage((Component)Component.translatable((String)"message.reusable_rockets.set_flight_duration", (Object[])new Object[]{duration, this.maxDuration.get()}), true);
            player.playSound(SoundEvents.STONE_BUTTON_CLICK_OFF, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        if (player.isFallFlying() && this.getUsesLeft(stack) > 0) {
            if (!((Boolean)Main.SERVER_CONFIG.allowRocketSpamming.get()).booleanValue() && this.isGettingBoosted(player)) {
                return InteractionResult.FAIL;
            }
            if (!world.isClientSide) {
                int usesLeft = this.getUsesLeft(stack);
                int duration = Math.min(this.getFlightDuration(stack), usesLeft);
                world.addFreshEntity((Entity)new FireworkRocketEntity(world, this.createDummyFirework((byte)duration), (LivingEntity)player));
                this.setUsesLeft(stack, Math.max(0, usesLeft - duration));
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    protected byte getFlightDuration(ItemStack stack) {
        return this.getRocketData(stack).getFlightDuration();
    }

    protected void setFlightDuration(ItemStack stack, byte duration) {
        RocketData rocketData = (RocketData)stack.get(Main.ROCKET_DATA_COMPONENT);
        if (rocketData == null) {
            rocketData = this.createDefaultRocketData();
        }
        stack.set(Main.ROCKET_DATA_COMPONENT, (Object)new RocketData(duration, rocketData.getUsesLeft()));
    }

    public void setUsesLeft(ItemStack stack, int usesLeft) {
        RocketData rocketData = (RocketData)stack.get(Main.ROCKET_DATA_COMPONENT);
        if (rocketData == null) {
            rocketData = this.createDefaultRocketData();
        }
        stack.set(Main.ROCKET_DATA_COMPONENT, (Object)new RocketData(rocketData.getFlightDuration(), usesLeft));
    }

    public int getUsesLeft(ItemStack stack) {
        return this.getRocketData(stack).getUsesLeft();
    }

    public int getMaxUses() {
        return this.maxUses.get();
    }

    public int getBarColor(ItemStack stack) {
        return ChatFormatting.DARK_RED.getColor();
    }

    public int getBarWidth(ItemStack stack) {
        return Math.round(13.0f - (float)(this.maxUses.get().doubleValue() - (double)this.getUsesLeft(stack)) * 13.0f / this.maxUses.get().floatValue());
    }

    public boolean isBarVisible(ItemStack stack) {
        return true;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.translatable((String)"tooltip.reusable_rockets.flight_duration", (Object[])new Object[]{this.getFlightDuration(stack), this.maxDuration.get()}).withStyle(ChatFormatting.GRAY));
        tooltip.add((Component)Component.translatable((String)"tooltip.reusable_rockets.uses", (Object[])new Object[]{this.getUsesLeft(stack), this.maxUses.get()}).withStyle(ChatFormatting.GRAY));
        tooltip.add((Component)Component.translatable((String)"tooltip.reusable_rockets.sneak_to_change").withStyle(ChatFormatting.GRAY));
        super.appendHoverText(stack, context, tooltip, flag);
    }

    protected ItemStack createDummyFirework(byte flightDuration) {
        ItemStack stack = new ItemStack((ItemLike)Items.FIREWORK_ROCKET);
        Fireworks fireworks = new Fireworks((int)flightDuration, Collections.emptyList());
        stack.set(DataComponents.FIREWORKS, (Object)fireworks);
        return stack;
    }

    public boolean isGettingBoosted(Player player) {
        return player.level().getEntitiesOfClass(FireworkRocketEntity.class, player.getBoundingBox().inflate(2.0), rocket -> rocket.attachedToEntity == player).stream().findAny().isPresent();
    }
}

