/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.rockets.item;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public class RocketData {
    public static final Codec<RocketData> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.BYTE.fieldOf("flight_duration").forGetter(RocketData::getFlightDuration), (App)Codec.INT.fieldOf("uses_left").forGetter(RocketData::getUsesLeft)).apply((Applicative)i, RocketData::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, RocketData> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BYTE, RocketData::getFlightDuration, (StreamCodec)ByteBufCodecs.VAR_INT, RocketData::getUsesLeft, RocketData::new);
    private final byte flightDuration;
    private final int usesLeft;

    public RocketData(byte flightDuration, int usesLeft) {
        this.flightDuration = flightDuration;
        this.usesLeft = usesLeft;
    }

    public byte getFlightDuration() {
        return this.flightDuration;
    }

    public int getUsesLeft() {
        return this.usesLeft;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RocketData that = (RocketData)o;
        return this.flightDuration == that.flightDuration && this.usesLeft == that.usesLeft;
    }

    public int hashCode() {
        int result = this.flightDuration;
        result = 31 * result + this.usesLeft;
        return result;
    }
}

