/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.rockets.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.maxhenkel.rockets.Main;
import de.maxhenkel.rockets.item.ItemReusableRocket;
import java.util.ArrayList;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class RefuelRecipe
extends CustomRecipe {
    private ItemStack rocket;
    private Ingredient fuel;

    public RefuelRecipe(ItemStack rocket, Ingredient fuel) {
        super(CraftingBookCategory.MISC);
        this.rocket = rocket;
        this.fuel = fuel;
    }

    public boolean matches(CraftingInput inv, Level worldIn) {
        return this.craft(inv) != null;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInput inv) {
        CraftingResult craft = this.craft(inv);
        if (craft == null) {
            return null;
        }
        return craft.remaining;
    }

    public ItemStack assemble(CraftingInput inv, HolderLookup.Provider provider) {
        CraftingResult craft = this.craft(inv);
        if (craft == null) {
            return null;
        }
        return craft.result;
    }

    public ItemStack getRocket() {
        return this.rocket;
    }

    public Ingredient getFuel() {
        return this.fuel;
    }

    public RecipeSerializer<? extends CustomRecipe> getSerializer() {
        return (RecipeSerializer)Main.CRAFTING_REFUEL.get();
    }

    public CraftingBookCategory category() {
        return CraftingBookCategory.MISC;
    }

    protected CraftingResult craft(CraftingInput inv) {
        ItemStack rocket = null;
        ArrayList<Integer> gunpowderSlotIndices = new ArrayList<Integer>();
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (stack.isEmpty()) continue;
            if (stack.getItem() instanceof ItemReusableRocket) {
                if (rocket != null) {
                    return null;
                }
                rocket = stack;
                continue;
            }
            if (!stack.is(Main.ROCKET_FUEL)) continue;
            gunpowderSlotIndices.add(i);
        }
        if (rocket == null) {
            return null;
        }
        ItemReusableRocket r = (ItemReusableRocket)rocket.getItem();
        int usesLeft = r.getUsesLeft(rocket);
        int maxUses = r.getMaxUses();
        if (gunpowderSlotIndices.size() <= 0 || usesLeft >= maxUses) {
            return null;
        }
        ItemStack rocketOut = rocket.copy();
        int count = Math.min(maxUses - usesLeft, gunpowderSlotIndices.size());
        NonNullList remaining = NonNullList.withSize((int)inv.size(), (Object)ItemStack.EMPTY);
        if (count < gunpowderSlotIndices.size()) {
            int reAddCount = gunpowderSlotIndices.size() - count;
            for (Integer index : gunpowderSlotIndices) {
                if (reAddCount <= 0) break;
                ItemStack gp = inv.getItem(index.intValue()).copy();
                gp.setCount(1);
                remaining.set(index.intValue(), (Object)gp);
                --reAddCount;
            }
        }
        r.setUsesLeft(rocketOut, usesLeft + count);
        return new CraftingResult(rocketOut, (NonNullList<ItemStack>)remaining);
    }

    private static class CraftingResult {
        public final ItemStack result;
        public final NonNullList<ItemStack> remaining;

        public CraftingResult(ItemStack result, NonNullList<ItemStack> remaining) {
            this.result = result;
            this.remaining = remaining;
        }
    }

    public static class RecipeRefuelSerializer
    implements RecipeSerializer<RefuelRecipe> {
        private static final MapCodec<RefuelRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)BuiltInRegistries.ITEM.byNameCodec().xmap(ItemStack::new, ItemStack::getItem).fieldOf("rocket").forGetter(recipe -> recipe.rocket), (App)Ingredient.CODEC.fieldOf("fuel").forGetter(recipe -> recipe.fuel)).apply((Applicative)builder, RefuelRecipe::new));
        private static final StreamCodec<RegistryFriendlyByteBuf, RefuelRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemStack.STREAM_CODEC, RefuelRecipe::getRocket, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, RefuelRecipe::getFuel, RefuelRecipe::new);

        public MapCodec<RefuelRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, RefuelRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

