/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.starterstructure_common_fabric.util;

import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.natamus.collective_common_fabric.data.GlobalVariables;
import com.natamus.collective_common_fabric.functions.BlockPosFunctions;
import com.natamus.collective_common_fabric.functions.DataFunctions;
import com.natamus.collective_common_fabric.functions.DimensionFunctions;
import com.natamus.collective_common_fabric.functions.SignFunctions;
import com.natamus.collective_common_fabric.functions.WorldFunctions;
import com.natamus.collective_common_fabric.schematic.ParseSchematicFile;
import com.natamus.collective_common_fabric.schematic.ParsedSchematicObject;
import com.natamus.starterstructure_common_fabric.config.ConfigHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2515;
import net.minecraft.class_2518;
import net.minecraft.class_2522;
import net.minecraft.class_2586;
import net.minecraft.class_2625;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3730;
import net.minecraft.class_3748;
import net.minecraft.class_5134;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;

public class Util {
    public static HashMap<class_1937, List<class_2338>> protectedMap = new HashMap();
    private static final String dirpath = DataFunctions.getConfigDirectory() + File.separator + "starterstructure";
    private static final File schematicDir = new File(dirpath + File.separator + "schematics");
    private static final File signDataDir = new File(dirpath + File.separator + "signdata");
    private static final Logger logger = LogUtils.getLogger();
    private static final String logPrefix = "[Starter Structure] ";

    public static boolean initDirs() {
        if (!schematicDir.isDirectory() && !schematicDir.mkdirs()) {
            return false;
        }
        if (!signDataDir.isDirectory()) {
            return signDataDir.mkdirs();
        }
        return true;
    }

    public static class_2338 generateSchematic(class_3218 serverLevel) {
        ParsedSchematicObject parsedSchematicObject;
        File[] listOfFiles;
        if (!schematicDir.isDirectory() && !Util.initDirs()) {
            logger.info("[Starter Structure] Unable to generate directories.");
            return null;
        }
        ArrayList<File> listOfSchematicFiles = new ArrayList<File>();
        for (File file : listOfFiles = schematicDir.listFiles()) {
            if (!file.getName().endsWith(".schem") && !file.getName().endsWith(".schematic") && !file.getName().endsWith(".nbt")) continue;
            listOfSchematicFiles.add(file);
        }
        if (listOfSchematicFiles.size() == 0) {
            logger.info("[Starter Structure] No schematics found to generate the starter structure.");
            return null;
        }
        File schematicFile = (File)listOfSchematicFiles.get(GlobalVariables.random.nextInt(listOfSchematicFiles.size()));
        if (!schematicFile.isFile()) {
            logger.info("[Starter Structure] Unable to find starter structure file.");
            return null;
        }
        boolean automaticCenter = schematicFile.getName().endsWith(".nbt");
        class_2338 structurePos = serverLevel.method_43126();
        if (ConfigHandler.shouldUseStructurePosition) {
            structurePos = new class_2338(ConfigHandler.generatedStructureXPosition, ConfigHandler.generatedStructureYPosition, ConfigHandler.generatedStructureZPosition);
        }
        if (ConfigHandler.ignoreTreesDuringStructurePlacement && (!ConfigHandler.shouldUseStructurePosition || ConfigHandler.generatedStructureYPosition == 0)) {
            structurePos = Util.getSpawnPos(serverLevel, BlockPosFunctions.getSurfaceBlockPos((class_3218)serverLevel, (int)structurePos.method_10263(), (int)structurePos.method_10260(), (boolean)true), false, false);
        }
        if (ConfigHandler.shouldUseStructureOffset) {
            structurePos = structurePos.method_10069(ConfigHandler.generatedStructureXOffset, ConfigHandler.generatedStructureYOffset, ConfigHandler.generatedStructureZOffset).method_10062();
        }
        try (FileInputStream fileInputStream = new FileInputStream(schematicFile);){
            parsedSchematicObject = ParseSchematicFile.getParsedSchematicObject((InputStream)fileInputStream, (class_1937)serverLevel, (class_2338)structurePos, (int)0, (boolean)false, (boolean)automaticCenter);
        }
        catch (Exception ex) {
            logger.info("[Starter Structure] Exception while attempting to parse schematic file.");
            ex.printStackTrace();
            return null;
        }
        if (!parsedSchematicObject.parsedCorrectly) {
            logger.info("[Starter Structure] The starter structure object was not parsed correctly.");
            return null;
        }
        class_2338 finalStructurePos = structurePos;
        MinecraftServer minecraftServer = serverLevel.method_8503();
        minecraftServer.execute(() -> {
            ArrayList<class_2338> protectedList = null;
            if (ConfigHandler.protectStructureBlocks) {
                protectedList = new ArrayList<class_2338>();
            }
            int yoffset = ConfigHandler.generatedStructureYOffset;
            logger.info("[Starter Structure] Generating starter structure with " + parsedSchematicObject.blocks.size() + " blocks.");
            for (Pair blockPair : parsedSchematicObject.blocks) {
                class_2680 blockState = (class_2680)blockPair.getSecond();
                class_2248 block = blockState.method_26204();
                if ((block instanceof class_3748 || block instanceof class_2515 || block instanceof class_2518) && ConfigHandler.generationIgnoreJigsawAndStructureBlocks) continue;
                serverLevel.method_8652((class_2338)blockPair.getFirst(), blockState, 3);
                if (protectedList == null) continue;
                protectedList.add((class_2338)blockPair.getFirst());
            }
            if (protectedList != null) {
                Util.writeProtectedList(serverLevel, protectedList);
            }
            minecraftServer.execute(() -> {
                parsedSchematicObject.placeBlockEntitiesInWorld((class_1937)serverLevel);
                class_2378 entityTypeRegistry = serverLevel.method_30349().method_30530(class_7924.field_41266);
                for (Pair blockEntityPair : parsedSchematicObject.getBlockEntities((class_1937)serverLevel)) {
                    class_2338 blockPos = (class_2338)blockEntityPair.getFirst();
                    class_2586 blockEntity = (class_2586)blockEntityPair.getSecond();
                    if (!(blockEntity instanceof class_2625)) continue;
                    class_2625 signBlockEntity = (class_2625)blockEntity;
                    List signLines = SignFunctions.getSignText((class_2625)signBlockEntity);
                    String firstLine = (String)signLines.get(0);
                    signLines.remove(0);
                    String signContent = String.join((CharSequence)"", signLines);
                    class_1297 newEntity = null;
                    if (firstLine.contains("[Mob]") || firstLine.contains("[Entity]")) {
                        Optional entityType = entityTypeRegistry.method_10223(class_2960.method_60654((String)signContent));
                        if (entityType.isPresent()) {
                            newEntity = ((class_1299)((class_6880.class_6883)entityType.get()).comp_349()).method_5883((class_1937)serverLevel, class_3730.field_16474);
                        }
                    } else {
                        if (!firstLine.contains("[NBT]")) continue;
                        String nbtFilePath = String.valueOf(signDataDir) + File.separator + signContent + ".txt";
                        File nbtTextFile = new File(nbtFilePath);
                        if (nbtTextFile.isFile()) {
                            for (int n = 1; n >= 0; --n) {
                                String rawNBT = "";
                                try {
                                    rawNBT = new String(Files.readAllBytes(Paths.get(nbtFilePath, new String[0])));
                                    class_2487 entityCompoundTag = class_2522.method_10718((String)rawNBT);
                                    Optional optionalNewEntity = class_1299.method_5892((class_2487)entityCompoundTag, (class_1937)serverLevel, (class_3730)class_3730.field_16474);
                                    if (!optionalNewEntity.isPresent()) continue;
                                    if (n != 1) {
                                        logger.info("[Starter Structure] Unable to parse the " + signContent + ".txt entitydata file. Attempting automatic fix.");
                                    }
                                    newEntity = (class_1297)optionalNewEntity.get();
                                    n = -1;
                                    continue;
                                }
                                catch (Exception ex) {
                                    logger.info("[Starter Structure] Unable to parse the " + signContent + ".txt entitydata file. Attempting automatic fix.");
                                    try {
                                        Util.attemptEntityDataFileFix(nbtFilePath, rawNBT);
                                        continue;
                                    }
                                    catch (IOException iOException) {
                                        // empty catch block
                                    }
                                }
                            }
                        }
                    }
                    if (newEntity == null) continue;
                    newEntity.method_5752().add("starterstructure.protected");
                    newEntity.method_5814((double)blockPos.method_10263() + 0.5, (double)blockPos.method_10264(), (double)blockPos.method_10260() + 0.5);
                    serverLevel.method_8649(newEntity);
                    serverLevel.method_8652(blockPos, class_2246.field_10124.method_9564(), 3);
                }
                if (ConfigHandler.spawnNonSignEntitiesFromSupportedSchematics && parsedSchematicObject.entities.size() > 0) {
                    for (Pair entityPair : parsedSchematicObject.entities) {
                        class_1297 newEntity = (class_1297)entityPair.getSecond();
                        newEntity.method_5752().add("starterstructure.protected");
                        serverLevel.method_8649(newEntity);
                    }
                }
                minecraftServer.execute(() -> {
                    float spawnAngle = serverLevel.method_43127();
                    if (!Util.isSpawnablePos((class_1937)serverLevel, finalStructurePos)) {
                        List<Integer> absoluteArray = Arrays.asList(-1, 1);
                        for (int i = 0; i <= 10; ++i) {
                            for (class_2338 aroundPos : class_2338.method_10094((int)(finalStructurePos.method_10263() - i), (int)(finalStructurePos.method_10264() - i), (int)(finalStructurePos.method_10260() - i), (int)(finalStructurePos.method_10263() + i), (int)(finalStructurePos.method_10264() + i), (int)(finalStructurePos.method_10260() + i))) {
                                class_2338 upPos = aroundPos.method_10084();
                                if (!Util.isSpawnablePos((class_1937)serverLevel, aroundPos) || !Util.isSpawnablePos((class_1937)serverLevel, upPos)) continue;
                                serverLevel.method_8554(aroundPos, spawnAngle);
                                return;
                            }
                        }
                    }
                });
            });
        });
        return structurePos;
    }

    private static void attemptEntityDataFileFix(String nbtFilePath, String rawNBT) throws IOException {
        String[] rawSplit = rawNBT.split("\\{", 2);
        if (rawSplit.length > 1) {
            String prefix = rawSplit[0];
            Object newRawNBT = rawSplit[1];
            Object idValue = "";
            if (prefix.contains(":")) {
                String[] prefixSplit;
                for (String word : prefixSplit = prefix.split(" ")) {
                    if (!word.contains(":")) continue;
                    idValue = "id:\"" + word + "\",";
                }
            }
            if (!((String)idValue).equals("")) {
                newRawNBT = "{" + (String)idValue + (String)newRawNBT;
                Files.write(Path.of(nbtFilePath, new String[0]), ((String)newRawNBT).getBytes(), new OpenOption[0]);
            }
        }
    }

    private static boolean isSpawnablePos(class_1937 level, class_2338 pos) {
        return level.method_8320(pos).method_26204().equals(class_2246.field_10124);
    }

    private static void writeProtectedList(class_3218 serverLevel, List<class_2338> protectedList) {
        protectedMap.put((class_1937)serverLevel, protectedList);
        String protectedPath = WorldFunctions.getWorldPath((class_3218)serverLevel) + File.separator + "data" + File.separator + "starterstructure" + File.separator + "protection" + File.separator + DimensionFunctions.getSimpleDimensionString((class_1937)serverLevel);
        File protectedPathDir = new File(protectedPath);
        if (!protectedPathDir.isDirectory()) {
            protectedPathDir.mkdirs();
        }
        try {
            FileWriter writer = new FileWriter(protectedPath + File.separator + "blocks.txt");
            for (class_2338 protectedPos : protectedList) {
                String coordinateString = protectedPos.method_10263() + "," + protectedPos.method_10264() + "," + protectedPos.method_10260();
                writer.write(coordinateString + "\n");
            }
            writer.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void readProtectedList(class_3218 serverLevel) {
        String protectedPath = WorldFunctions.getWorldPath((class_3218)serverLevel) + File.separator + "data" + File.separator + "starterstructure" + File.separator + "protection" + File.separator + DimensionFunctions.getSimpleDimensionString((class_1937)serverLevel);
        File protectedPathDir = new File(protectedPath);
        if (!protectedPathDir.isDirectory()) {
            return;
        }
        String protectedFilePath = protectedPath + File.separator + "blocks.txt";
        if (!new File(protectedFilePath).isFile()) {
            return;
        }
        try {
            String rawProtectedList = new String(Files.readAllBytes(Paths.get(protectedFilePath, new String[0])));
            ArrayList<class_2338> newProtectedList = new ArrayList<class_2338>();
            for (String coordinateString : rawProtectedList.split("\n")) {
                String[] csspl = coordinateString.split(",");
                if (csspl.length != 3) continue;
                try {
                    newProtectedList.add(new class_2338(Integer.parseInt(csspl[0]), Integer.parseInt(csspl[1]), Integer.parseInt(csspl[2])));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (newProtectedList.size() > 0) {
                protectedMap.put((class_1937)serverLevel, newProtectedList);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void processEntityMovementOnJoin(class_1297 entity) {
        if (entity.method_5752().contains("starterstructure.protected") && ConfigHandler.preventSpawnedEntityMovement && entity instanceof class_1309) {
            ((class_1309)entity).method_5996(class_5134.field_23719).method_6192(0.0);
        }
    }

    public static class_2338 getSpawnPos(class_3218 serverLevel, class_2338 blockPos, boolean withOffset, boolean onSurface) {
        int x = blockPos.method_10263();
        int y = blockPos.method_10264();
        int z = blockPos.method_10260();
        if (ConfigHandler.shouldUseSpawnCoordinates) {
            x = ConfigHandler.spawnXCoordinate;
            y = ConfigHandler.spawnYCoordinate;
            z = ConfigHandler.spawnZCoordinate;
            if (ConfigHandler.spawnYCoordinate != 0) {
                onSurface = false;
            }
        }
        if (ConfigHandler.shouldUseSpawnCoordOffsets && withOffset) {
            x += ConfigHandler.spawnXCoordOffset;
            y += ConfigHandler.spawnYCoordOffset;
            z += ConfigHandler.spawnZCoordOffset;
        }
        if (onSurface) {
            y = BlockPosFunctions.getSurfaceBlockPos((class_3218)serverLevel, (int)x, (int)z, (boolean)ConfigHandler.ignoreTreesDuringStructurePlacement).method_10264();
        }
        if (y < serverLevel.method_31607()) {
            y = serverLevel.method_31607() + 1;
        } else if (y > serverLevel.method_31600()) {
            y = serverLevel.method_31600() - 1;
        }
        return new class_2338(x, y, z);
    }
}

